<?php include('header.php');?>
    <link rel="stylesheet" href="./css/get-started.css?v=112" />
    
    <section class="welcome">
      <div class="container">
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <img src="./images/renew-image-1-border.png" class="img-fluid" alt="" />
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <h2>Welcome to <span>Renew</span></h2>
            <h3>Psychotherapy Center, LLC</h3>
            <p>
              At <strong>Renew Psychotherapy Center, LLC</strong>, we guide you
              beyond healing, focusing on performance, solutions, and personal
              growth. <br />Our integrative and holistic approach is rooted in
              scientific principles and wisdom, offering services that address
              educational, behavioral health, and developmental needs.
            </p>
            <p>
              <strong>The R.E.N.E.W. Framework</strong> outlines our services and areas of expertise, directing our comprehensive approach to wellness, mental health, and personalized care.
            </p>
          </div>
        </div>
      </div>
    </section>
    <section class="renew">
      <div class="container">
        <div class="row">
          <div class="col-12 block-cards">
            <card>
              <h6>R</h6>
              <img src="./images/renew-image-r.png" />
              <div class="text">
                <h3>Retreats</h3>
                <p>
                  Join our transformative wellness and adventure retreats, where
                  networking, self-reflection, self-care, and fun come together.
                  Rejuvenate in inspiring locations while earning certifications
                  and Continuing Education (CE) credits, all while empowering
                  your resiliency.
                </p>
                <a href="retreats" class="button is-fifty"><div>+</div></a>
              </div>
            </card>
            <card>
              <h6>E</h6>
              <img src="./images/renew-image-emdr.png" />
              <div class="text">
                <h3>EMDR Therapy & Evidence-Based Approaches</h3>
                <p>
                  Our compassionate psychotherapy services for individuals,
                  couples, groups, and families utilize evidence-based
                  treatments, such as EMDR, CBT, DBT, SFT, ACT, MI and
                  eco-therapy, to support mental wellness.
                </p>
                <a href="emdr" class="button is-fifty"><div>+</div></a>
              </div>
            </card>
            <card>
              <h6>N</h6>
              <img src="./images/renew-image-lens.png" />
              <div class="text">
                <h3>Neurofeedback: LENS</h3>
                <p>
                  Our advanced LENS sessions optimize brain function, improve
                  emotional regulation, and foster well-being.
                </p>
                <a href="lens" class="button is-fifty"><div>+</div></a>
              </div>
            </card>
            <card>
              <h6>E</h6>
              <img src="./images/renew-image-coaching.png" />
              <div class="text">
                <h3>Education, Coaching & Clinical Supervision</h3>
                <p>
                  We provide professional teaching, mentorship, coaching, and
                  clinical supervision, delivering personalized strategies
                  rooted in evidence-based practices and real-world experience
                  to empower growth and success.
                </p>
                <a href="coaching" class="button is-fifty"><div>+</div></a>
              </div>
            </card>
            <card>
              <h6>W</h6>
              <img src="./images/renew-image-t.png" />
              <div class="text">
                <h3>Workshops, Training & Speaking Engagements</h3>
                <p>
                  Enhance professional development through advanced training
                  sessions, workshops, and speaking engagements offering CE
                  credits and certifications.
                </p>
                <a href="trainings" class="button is-fifty"><div>+</div></a>
              </div>
            </card>
          </div>
        </div>
      </div>
    </section>
    <section class="about">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h2 class="title">Mission, Vision <br />& Values</h2>
            <div class="container-slider">
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Mission</h3>
                      <hr />
                      <p>
                        Our mission is to provide accessible, compassionate, and
                        transformative educational, developmental, and
                        behavioral health services. We empower individuals,
                        organizations, and communities by fostering inclusive
                        and healing experiences
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/about-slider-1.png"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Vision</h3>
                      <hr />
                      <p>
                        We envision a world where mental healthcare, holistic
                        well-being, and social justice are integral to fostering
                        human connection, compassion, and equity for all.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/get-started-slider-vision.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>

              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Core Values</h3>
                      <hr />
                      <p>
                        Our core values shape every aspect of our work. We are
                        committed to creating a space that embodies these
                        guiding principles:
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-values.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Servant Leadership</h3>
                      <hr />
                      <p>
                        We lead with empathy and integrity, prioritizing
                        decisions that ensure the well-being of current and
                        future generations.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/get-started-slider-value-1.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Stewardship</h3>
                      <hr />
                      <p>
                        We carefully manage our resources to benefit the
                        community and the environment, ensuring lasting
                        sustainability and a positive impact.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-value-stewardship.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Collaboration</h3>
                      <hr />
                      <p>
                        We cultivate a collaborative environment where
                        practitioners, clients, and communities work together to
                        foster growth, wellness, and resilience.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-value-collaboration.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Ethical Standards & Transparency</h3>
                      <hr />
                      <p>
                        We uphold the highest ethical standards, ensuring our
                        actions are honest, accountable, and guided by clear,
                        open communication.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-value-transparencia.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Continuous Learning & Growth</h3>
                      <hr />
                      <p>
                        We are committed to innovation, lifelong learning, and
                        the pursuit of best practices that ensure the highest
                        quality of care.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-value-aprendizaje.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Compassion</h3>
                      <hr />
                      <p>
                        Every interaction is rooted in kindness, respect, and
                        understanding, creating spaces where all individuals
                        feel understood, valued, and supported.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-value-compasion.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Diversity, Equity & Inclusion</h3>
                      <hr />
                      <p>
                        We celebrate diversity and actively promote equity and
                        inclusion, ensuring that our services are accessible and
                        welcoming to all, regardless of background or identity.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-value-diversity.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
              <div class="slider">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>Holistic Wellness</h3>
                      <hr />
                      <p>
                        We recognize mind, body, and spirit interconnectedness,
                        integrating traditional and innovative approaches to
                        promote balanced, optimal health.
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/slider-core-holistic-wellness.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
            </div>
            <div class="container__buttons d-flex">
              <button class="btn left owl-prev" id="prev">
                <img src="./images/icon-chevron-left.png" />
              </button>
              <button class="btn right owl-next" id="next">
                <img src="./images/icon-chevron-right.png" />
              </button>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="welcome">
      <div class="container">
        <div class="row team">
          <div class="col-12 col-sm-12 col-md-12 col-lg-4">
            <h2>Visionary Team!</h2>
            <span class="circle-chevron-right"><img src="./images/icon-arrow-right-color.png"></span>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-8">
            <div class="row">
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-linda-timme" class="btn-team active">
                  <div>+</div>
                  <img src="./images/team-person-1.png" class="img-fluid" />
                  <h5>Dr. Linda Timme</h5>
                </a>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-david-timme" class="btn-team">
                  <div>+</div>
                  <img src="./images/team-person-2.png" class="img-fluid" />
                  <h5>David Timme</h5>
                </a>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-robin-vaneerden" class="btn-team">
                  <div>+</div>
                  <img src="./images/team-person-3.png" class="img-fluid" />
                  <h5>Robin VanEerden</h5>
                </a>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 text-start">
            <img src="./images/mentor-image-1.jpg" class="img-fluid" alt="" />
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <h2 class="pb-0">Dr. Linda Timme</h2>
            <h3>
              DSW, MSW, LCSW, LCSW-C, Licensed Psychologist <br>
              Founder and Clinical Director
            </h3>
            <p class="mb-4">
              Dr. Linda is a highly respected psychotherapist, educator, and
              global wellness advocate, with over 15 years of extensive
              experience. She has received numerous accolades for her unwavering
              commitment to behavioral health, trauma recovery, crisis
              intervention, and professional development. As a bilingual
              professional, she is fluent in English and Spanish. Her approach
              involves kindness, honesty, integrity, and a positive outlook. Dr.
              Linda's work ignites hope, uplifts communities, and empowers
              individuals to forge a brighter, more equitable future.
            </p>
            <p>
              Dr. Linda grew up overseas, an experience that shaped her global perspective and fostered a deep appreciation for diverse cultures. Immersed in different ways of life, she developed a profound understanding of human resilience and the interconnectedness of healing. This journey ignited her passion for trauma-informed care, motivating her to go beyond traditional approaches and create transformative spaces for growth. Committed to holistic wellness and evidence-based practices, she empowers professionals to lead with compassion, break barriers, and make a lasting impact.
            </p>
          </div>
        </div>
      </div>
    </section>
<?php include('_request-an-appointment.php');?>
<?php include('footer.php');?>