<?php include('header.php');?>
    <link rel="stylesheet" href="./css/biographies.css" />
    <section class="welcome">
      <div class="container">
        <div class="row team">
          <div class="col-12 col-sm-12 col-md-12 col-lg-4">
            <h2>Visionary Team!</h2>
            <span class="circle-chevron-right"><img src="./images/icon-arrow-right-color.png"></span>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-8">
            <div class="row">
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-linda-timme" class="btn-team">
                  <div>+</div>
                  <img src="./images/team-person-1.png" class="img-fluid" />
                  <h5>Dr. Linda Timme</h5>
                </a>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-david-timme" class="btn-team active">
                  <div>+</div>
                  <img src="./images/team-person-2.png" class="img-fluid" />
                  <h5>David Timme</h5>
                </a>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-robin-vaneerden" class="btn-team">
                  <div>+</div>
                  <img src="./images/team-person-3.png" class="img-fluid" />
                  <h5>Robin VanEerden</h5>
                </a>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 text-center">
            <img src="./images/david-timme.png" class="img-fluid" alt="" />
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <h2 class="pb-0">David Timme</h2>
            <h3>Physician Assistant (PA)</h3>
            <p>
              David Timme is a highly experienced Physician Assistant
              specializing in psychiatry, with over 45 years of dedicated
              service in the field. His expertise is recognized through numerous
              prestigious awards, including the Excellence in Community Mental
              Health Services Award from NAMI Pennsylvania and honors from
              Dauphin County's Mental Health Services for his outstanding
              contributions to mental health care.
            </p>
          </div>
        </div>
      </div>
    </section>
    <section class="renew">
      <div class="container">
        <div class="row">
          <div class="col-12 block-cards btn-container">
            <card class="tab-btn active" data-id="1">
              <div class="text">
                <h3>Educational Background</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="2">
              <div class="text">
                <h3>Clinical Expertise</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="3">
              <div class="text">
                <h3>Commitment to Advocacy</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="4">
              <div class="text">
                <h3>Services Offered</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="5">
              <div class="text">
                <h3>Holistic & Wellness Expertise</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 block-detail">
            <div class="row my-5">
              <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                <div class="text">
                  <h2>David Timme</h2>
                  <h3>Professional</h3>
                  <h4>Journey</h4>
                  <hr />
                </div>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-6 about-content">
                <div class="content active" id="1">
                  <p>
                    David began his journey in healthcare at the Penn State
                    College of Medicine, where he earned a degree in Physician
                    Assistant Studies. He continued his education, focusing on
                    chemical and social studies, ensuring he remains at the
                    forefront of medical advancements and is equipped to deliver
                    comprehensive, effective healthcare services.
                  </p>
                </div>
                <div class="content" id="2">
                  <p>
                    Throughout his career, David has been a leader in mental
                    health, integrating the latest research and best practices
                    into his clinical work. His expertise spans a wide range of
                    psychiatric conditions, from severe mental illnesses such as
                    schizophrenia and bipolar disorder to more common issues
                    like anxiety and depression. He has experience in various
                    settings, including emergency psychiatry, outpatient care,
                    inpatient hospitals, correctional facilities, and community
                    mental health centers.
                  </p>
                  <p>
                    David's approach emphasizes holistic care, often
                    collaborating with other healthcare professionals to promote
                    long-term wellness for his clients. He combines medication
                    management with evidence-based therapeutic strategies to
                    support recovery and resilience.
                  </p>
                </div>
                <div class="content" id="3">
                  <p>
                    David is deeply committed to serving diverse populations and
                    providing compassionate, evidence-based care. He is an
                    active mental health advocate, volunteering with local
                    organizations to raise awareness about mental wellness.
                    Additionally, he enjoys mentoring students and new
                    graduates, sharing his extensive knowledge to help shape the
                    next generation of healthcare practitioners.
                  </p>
                </div>
                <div class="content" id="4">
                  <ul>
                    <li>Professional Development</li>
                    <li>Expert Consultation</li>
                    <li>LENS Neurofeedback</li>
                    <li>Transformative Retreats</li>
                    <li>
                      Meditation, Energy Healer, Yoga & Wellness Practitioner
                    </li>
                  </ul>
                </div>
                <div class="content" id="5">
                  <ul>
                    <li>Energy Healer Practitioner</li>
                    <li>Wellness Practitioner</li>
                    <li>Coach Practitioner</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <br>
    <br>
    <br>
    <br>
    <br>
     <script>
       /*Paginaton*/
      const cards = document.querySelectorAll(".btn-container > card");
      const $content = document.querySelectorAll(".content");

      cards.forEach((card, key) => {
        card.addEventListener(
          "click",
          function () {
            tabId = card.dataset.id;
            console.log(tabId);

            $content.forEach((cont) => {
              cont.classList.remove("active");
              if (cont.id == tabId) {
                cont.classList.add("active");
              }
            });

            cards.forEach((tab) => {
              tab.classList.remove("active");
              if (tab.dataset.id == tabId) {
                tab.classList.add("active");
              }
            });
          },
          false
        );
      });
      </script>
<?php include('footer.php');?>