<?php include('header.php');?>
<link rel="stylesheet" href="./css/emdr.css?v=112" />
    
    <section class="ochs-labs">
      <div class="container">
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <h3 class="text-center">Psychotherapy Programs</h3>
            <h4 class="skyblue text-center">
              Personalized and Comprehensive Care for Individuals, Couples, Groups, and Families
            </h4>
            <p>
              At <strong>Renew Psychotherapy Center,</strong> you are never
              alone. Our therapy plans are tailored to foster personal growth,
              enhance relationships, and provide family support. Whether
              addressing trauma, anxiety, depression, grief, relationship
              challenges, or the effects of serious illness, our compassionate
              team is dedicated to guiding you through life’s complexities.
            </p>
            <p>
              Led by a Trauma-Focused Therapist, Certified
              EMDR Clinician, and
              EMDRIA-approved consultant. We also specialize in
              evidence-based modalities such as EMDR (Eye Movement
              Desensitization and Reprocessing), CBT (Cognitive Behavioral
              Therapy), DBT (Dialectical Behavior Therapy), to help members of
              all ages process emotional and psychological challenges.
            </p>
            <p>
              Whether through individual, Couple & Family, or group therapy, our
              approach fosters recovery, connection, and enduring well-being. By
              integrating neurobiological insights with personalized treatment,
              we help you move toward a happier, healthier, and more fulfilling
              life.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <img src="./images/emdr-image-2-border.png" class="img-fluid" alt="" />
          </div>
        </div>
      </div>
    </section>
    <section>
      <div class="container">
        <div class="row">
          <div class="col-12 text-center">
            <h3 class="skyblue">Steps to Begin Your Healing Journey:</h3>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-5 col-xl-5">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/icon-step-1.png"
                width="75"
                class="img-arrow"
              />
            </div>
            <h5>01. Contact Us</h5>
            <p>
              Schedule a consultation to determine whether hourly or intensive
              psychotherapy meets your needs. Explore flexible options: at home,
              in-office, virtually, or at one of our serene retreat locations.
            </p>
          </div>
          <div
            class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2 d-flex align-items-center"
          >
            <img src="./images/icon-arrow-right.png" class="img-arrow d-none d-lg-block d-xl-block" />
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-5 col-xl-5">
            <div class="step-circle d-flex align-items-center text-center">
              <img
                src="./images/icon-step-2.png"
                height="70"
                class="img-arrow"
              />
            </div>
            <h5>02. Preparation, Assessment, and Planning</h5>
            <p>
              Begin with a comprehensive evaluation to define your goals and
              needs. Receive a personalized plan that includes resourcing,
              psychoeducation, safety strategies, and grounding techniques to
              prepare for successful therapy.
            </p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-5 col-xl-5"></div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2"></div>
          <div
            class="col-12 col-sm-12 col-md-12 col-lg-5 col-xl-5 d-flex align-items-center"
          >
            <img
              src="./images/icon-arrow-right.png"
              class="img-arrow rotate-botton d-none d-lg-block d-xl-block"
            />
          </div>
        </div>
        <div class="row block-change-order">
          <div class="col-12 col-sm-12 col-md-12 col-lg-5 col-xl-5 change-order-one">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/icon-step-4.png"
                width="70"
                class="img-arrow"
              />
            </div>
            <h5>04. Integration and Follow-Up</h5>
            <p>
              Celebrate your accomplishments with a detailed summary of progress
              and a clear path for sustained well-being.
            </p>
          </div>
          <div
            class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2 d-flex align-items-center change-order-two"
          >
            <img
              src="./images/icon-arrow-right.png"
              class="img-arrow rotate-left d-none d-lg-block d-xl-block"
            />
 
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-5 col-xl-5 change-order-three">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/icon-step-3.png"
                width="70"
                class="img-arrow"
              />
            </div>
            <h5>03. Focused Psychotherapy Sessions</h5>
            <p>
              Engage in therapy designed for accelerated healing, from weekly
              one-hour sessions to intensive 5-day programs.
            </p>
          </div>
        </div>
      </div>
    </section>

    <section class="ochs-labs">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <img
              src="./images/emdr-comprehensive-image-1.jpg"
              class="img-fluid"
            />
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 text-center">
            <h3 class="text-center">
              Comprehensive Therapy for Grief, Loss, PTSD, and Trauma
            </h3>
            <h5>
              Are you stuck in survival mode, feeling overwhelmed and unable to
              move forward?
            </h5>
            <p>
              <strong>At Renew Psychotherapy Center,</strong> we are committed
              to guiding our members on their healing journeys with compassion,
              skill, and a personalized approach. Healing is an individual
              process rooted in connection and community. Through our
              Individual, Couple & Family, and Group Therapy Services and
              supportive networks, we provide a safe, nurturing space for
              connections and rediscovering yourself.
            </p>
            <p>
              Our skilled therapists integrate clinical knowledge with
              compassionate care, utilizing evidence-based modalities such as
              EMDR, TF-CBT, CPT, MBCT, and specialized approaches. We also
              embrace holistic techniques, including mindfulness meditation,
              grounding exercises, and creative therapies, seamlessly woven into
              treatment to promote resilience and lasting well-being.
            </p>
          </div>
        </div>

        <div class="row mt-5">
          <div class="col-12 text-center">
            <h3>A Broader Spectrum of Trauma and Loss We Address:</h3>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6">
            <img
              src="./images/emdr-comprehensive-image-2.jpg"
              class="img-fluid"
            />
          </div>
          <div
            class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6 d-flex align-items-center"
          >
            <ul>
              <li>
                <strong>Bereavement and Grief</strong>: Loss of loved ones,
                identity, or career.
              </li>
              <li>
                <strong>Vicarious Trauma</strong>: Emotional exhaustion,
                burnout, and stress experienced by caregivers and professionals.
              </li>
              <li>
                <strong>Generational Trauma</strong>: Challenges with identity,
                self-esteem, and relationships.
              </li>
              <li>
                <strong>Interpersonal Trauma</strong>: Bullying, domestic
                violence, or sexual assault.
              </li>
              <li>
                <strong>Childhood Trauma</strong>: Abuse, neglect, anger, or
                parental separation.
              </li>
              <li>
                <strong>Health-Related Trauma</strong>: Chronic illness or
                caregiver stress.
              </li>
              <li>
                <strong>Violence and Crime</strong>: Human trafficking,
                terrorism, or mass violence.
              </li>
              <li>
                <strong>Accidents and Disasters</strong>: Natural disasters or
                life-threatening events.
              </li>
              <li>
                <strong>Identity-Based Trauma</strong>: Experiences of
                discrimination or marginalization.
              </li>
            </ul>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-center my-4">
            <h4>
              Discover the power of psychotherapy. Reclaim your life and start
              your journey today!
            </h4> 
          </div>
        </div> 
         <div class="row">
          <div class="col-12 text-center">
             <a href="#modalPay" class="btn price" data-bs-toggle="modal" role="button">Get Started</a>
          </div>
        </div>

      </div>
    </section>
    <section class="">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h3>
              Comprehensive Therapy for Neurodiversity, Depression, and Anxiety
            </h3>
            <h5>
              Are you feeling weighed down by hopelessness, sadness, or
              irritability?
            </h5>
            <p>
              At Renew Psychotherapy Center, we believe in the power of
              personalized care and innovative methods to help you thrive. Let
              us walk alongside you on your resilience, recovery, and renewal
              journey. Our holistic, science-based therapy programs are designed
              to foster resilience, gratitude, and personal growth. We are
              dedicated to helping you navigate challenges and achieve lasting
              well-being. In a compassionate and supportive environment, we
              provide the tools and guidance to build a strong foundation for
              enduring mental and emotional health, empowering you to lead a
              fulfilling life and feel hopeful about the future.
            </p>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
            <img
              src="./images/emdr-comprehensive-image-3.jpg"
              class="img-fluid"
            />
          </div>
          <div
            class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 d-flex align-items-center flex-column"
          >
            <h3>Our Offerings</h3>
            <ul>
              <li>
                <strong>Group Support:</strong> Build meaningful connections in
                a safe, nurturing space, fostering a sense of belonging and
                shared understanding.
              </li>
              <li>
                <strong>Evidence-Based Modalities:</strong> Benefit from
                personalized therapies, such as EMDR, SFT, PCT, and CBT.
              </li>
              <li>
                <strong>Neurodiversity Strategies:</strong> Enhance
                communication, deepen understanding, and strengthen
                relationships through tailored approaches celebrating individual
                strengths.
              </li>
              <li>
                <strong>Immersive Experiences:</strong> Engage in mindfulness
                practices, nature-based therapy, and creative outlets to nurture
                emotional balance and promote holistic healing.
              </li>
            </ul>
          </div>
        </div> 
         <div class="row">
          <div class="col-12 text-center mt-5">
             <a href="#modalPay" class="btn price" data-bs-toggle="modal" role="button">Plan Your Visit</a>
          </div>
        </div>

      </div>
    </section>

    <section class="">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <img
              src="./images/emdr-cross-cultural-image-1.jpg"
              class="img-fluid"
            />
          </div>
        </div>
        <div class="row">
          <div class="col-12 mt-5 text-left">
            <h3 class="text-center">
              Cross-Cultural & Immigration-Related Therapy
            </h3>
            <h5>
              Are you seeking support to navigate immigration transitions
              confidently and honor your sacrifices?
            </h5>
            <p>
              At Renew Psychotherapy Center, we create welcoming, inclusive
              spaces celebrating diverse identities and providing tailored
              support for navigating life’s transitions and challenges. With a
              compassionate approach rooted in cultural humility, we integrate
              evidence-based strategies
              <strong>(EMDR, ACT, CPT, CBT, and other interventions)</strong> to
              foster growth, healing, and connection. We honor the richness of
              language, culture, and beliefs in every community, helping clients
              reprocess distressing memories, uncover inner strengths, and build
              lasting emotional resilience.
            </p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
            <img
              src="./images/emdr-cross-cultural-image-2.jpg"
              class="img-fluid"
            />
          </div>
          <div
            class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 d-flex align-items-center flex-column"
          >
            <h3>Our Services</h3>
            <ul>
              <li>
                <strong>Cross-Cultural Psychotherapy:</strong> Guidance and
                support for navigating identity challenges, cultural adaptation,
                and resilience building.
              </li>
              <li>
                <strong>Family Integration Support:</strong> Helping families
                adapt to change while preserving core values and fostering
                unity.
              </li>
              <li>
                <strong>Conflict Resolution:</strong> Mediation strategies
                designed to enhance communication and understanding across
                cultural differences.
              </li>
              <li>
                <strong>Immigration Evaluations:</strong> Comprehensive mental
                health assessments addressing trauma, hardship, and other
                challenges related to immigration.
              </li>
            </ul>
          </div>
        </div>
    
         <div class="row">
          <div class="col-12 text-center mt-5">
             <a href="#modalPay" class="btn price" data-bs-toggle="modal" role="button">Secure Your Session</a>
          </div>
        </div>

      </div>
    </section>

    <section class="">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <img src="./images/emdr-couples-image-1.jpg" class="img-fluid" />
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-left my-5">
            <h3 class="text-center">Evidence-Based Couples Therapy</h3>
            <p>
              <strong
                >Are you ready to create a resilient, fulfilling
                partnership?</strong
              >
            </p>
            <p>
              Reignite trust, improve communication, and deepen your emotional
              connection with our compassionate, care-guided couples therapy
              program. Combining powerful approaches like EMDR Therapy, CBCT,
              EFT, Imago, Attachment Therapy, the Gottman Method, and other
              interventions. We address the root causes of conflict and
              emotional distress to help you heal and thrive together. Designed
              for couples at every stage, this program provides proven tools to
              resolve past wounds, break unhealthy cycles, and create lasting
              intimacy.
            </p>
            <p>
              Discover how empathy, secure attachment, and a renewed sense of
              partnership can transform your relationship into a source of
              strength, love, and connection. Let us guide you toward a future
              built on trust, compassion, and resilience.
            </p>
          </div>
          <h5 class="mx-auto mb-5">
            Your journey to a stronger, healthier relationship begins today!
          </h5>
        </div> 
         <div class="row">
          <div class="col-12 text-center">
             <a href="#modalPay" class="btn price" data-bs-toggle="modal" role="button">Plan Your Visit</a>
          </div>
        </div>


      </div>
    </section>

    <section class="">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <img src="./images/emdr-family-image-1.jpg" class="img-fluid" />
          </div>
        </div>
        <div class="row">
          <div class="col-12 mt-5">
            <h3 class="mx-auto text-center">
              Empowering Families, Strengthening Bonds
            </h3>
            <p>
              <strong
                >What does the future hold for your family’s journey
                together?</strong
              >
            </p>
            <p>
              Our Family Therapy services offer families a safe, supportive
              space to overcome challenges, improve communication, and build
              deeper connections. We address relational conflicts, behavioral
              concerns, and emotional struggles using evidence-based approaches
              like Family Systems Therapy, Parent-Child Interaction Therapy
              (PCIT), and Attachment-Based Family Therapy (ABFT). We aim to
              foster understanding, build trust, and cultivate resilience,
              helping families navigate transitions with harmony and strength.
              Family therapy creates opportunities for meaningful conversations,
              repairs relationships, and develops healthy patterns of
              interaction.
            </p>
          </div>
          <h5 class="mx-auto">
            Together, we’ll help your family grow, heal, and thrive—building a
            brighter, more connected future.
          </h5>
        </div>

             <div class="row">
          <div class="col-12 mt-5">
            <p class="text-center">
              We focus on providing flexible options. Insurance is not accepted
              for intensive therapy, group sessions, couples, and family
              therapy, or retreat programs. We’re happy to provide a superbill
              to support out-of-network reimbursement for individual treatment.
            </p>
          </div>
        </div> 
         <div class="row">
          <div class="col-12 text-center mt-4">
            <h3>Engaging & Client-Friendly:</h3>
          </div>
          <div class="col-12 text-center">
             <a href="#modalPay" class="btn price" data-bs-toggle="modal" role="button">Reserve Your Spot</a>
          </div>
        </div>
      </div>
    </section>

<div class="modal fade" id="modalPay" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">

    <section class="mb-0 pb-0">
        <div class="container">
          <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center">
                    <h3 class="mb-5">Self-Pay: Program Options and Pricing</h3>
                  </div>
                </div>
          <div class="row">
          <div class="col-12">
            <table>
              <tbody><tr>
                <th>Program</th>
                <th>Duration</th>
                <th>Cost</th>
              </tr>
              <tr>
                <td>Online Group Therapy</td>
                <td>55m</td>
                <td><a href="javascript:void(0)" class="btn price">Book Now</a></td>
              </tr>
              <tr>
                <td>Individual Therapy</td>
                <td>55m</td>
                <td><a href="javascript:void(0)" class="btn price">Book Now</a></td>
              </tr>
              <tr>
                <td>Half-Day Intensive</td>
                <td>3 hours</td>
                <td><a href="javascript:void(0)" class="btn price">Book Now</a></td>
              </tr>
              <tr>
                <td>Full-Day Intensive</td>
                <td>6 hours</td>
                <td><a href="javascript:void(0)" class="btn price">Book Now</a></td>
              </tr>
              <tr>
                <td>Stunning Retreat</td>
                <td>2–5 days</td>
                <td><a href="javascript:void(0)" class="btn price">Book Now</a></td>
              </tr>
            </tbody></table>
          </div>
        </div>
      <div class="row">
          <div class="col-12">
            <p class="text-center mt-5">
              We focus on providing flexible options. Insurance is not accepted
              for intensive therapy, group sessions, couples and family therapy,
              or retreat programs. For individual therapy, we’re happy to
              provide a superbill to support out-of-network reimbursement.
            </p>
          </div>
        </div>
  </div>      
 </section>
  </div>
 
    </div>
  </div>
</div>
 
<?php include('_request-an-appointment.php');?>
<?php include('footer.php');?>