<?php include('header.php');?>
<link rel="stylesheet" href="./css/training.css" />
  <section class="impar ">
      <div class="container">
        <div class="row">    
            <div class="col-12 col-sm-12 col-md-12 col-lg-12 ">
              <h3 class="text-center">Resources</h3>
              <p>At Renew Psychotherapy Center, LLC, we believe in the strength of connection and the power of support. Whether facing challenges or seeking inspiration, we are here to guide you.</p>
              
         
            </div>
        </div>
<div class="row">
  <div class="col-12 col-sm-12 col-md-12 col-lg-12 mt-3">
  <h4 class="pb-1">Emergency Assistance</h4>
  <p>
    If you are experiencing a medical or mental health emergency, please dial 911 or visit your nearest emergency room immediately. <br>
  
    Below is a list of resources that may support you or your loved ones.
  </p>
  </div>
</div>
<div class="row mt-3">
  <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
    <h4>EMDR Therapy</h4>
  <ul>
  <li><a href="https://www.emdria.org/" target="_blank">EMDRIA (EMDR International Association)</a></li>
  <li><a href="https://www.emdria.org/resource/emdr-therapy-for-adults-brochure-option-1/" target="_blank">EMDR Brochure</a></li>
  <li><a href="https://www.youtube.com/watch?v=Pkfln-ZtWeY" target="_blank">Introduction to EMDR Therapy Video</a></li>

  </ul>
  </div>
  <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
    <h4>CBT (Cognitive Behavioral Therapy)</h4>
    <ul>
  <li><a href="https://www.nacbt.org/" target="_blank">National Association of Cognitive-Behavioral Therapists (NACBT)</a></li>
  <li><a href="https://www.nacbt.org/whatiscbt-htm/" target="_blank">CBT for Beginners: An Introduction to CBT</a></li>
  <li><a href="https://www.apa.org/ptsd-guideline/patients-and-families/cognitive-behavioral" target="_blank">Understanding CBT: A Quick Guide to How It Works</a></li>
  </ul>
  </div>
</div>
<div class="row mt-3">
  <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
    <h4>DBT (Dialectical Behavior Therapy)</h4>
    <ul>
    <li><a href="https://behavioraltech.org/" target="_blank">Behavioral Tech: DBT Resources and Information</a></li>
    <li><a href="https://behavioraltech.org/resources/faqs/dialectical-behavior-therapy-dbt/" target="_blank">Training Manual for DBT Overview</a></li>
    <li><a href="https://www.dbtselfhelp.com/" target="_blank"> DBT Skills Online</a></li>
    </ul>
  </div>
  <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
    <h4>SFBT (Solution-Focused Brief Therapy)</h4>
    <ul>
      <li><a href="https://www.sfbta.org/" target="_blank">Solution Focused Brief Therapy Association (SFBTA)</a></li> 
      <li><a href="https://www.sfbta.org/about_sfbt.html" target="_blank">What is Solution-Focused Brief Therapy?</a></li>
      <li><a href="https://www.youtube.com/playlist?list=PL8D22AF4E3AA8D03D" target="_blank"> SFBT in Action: Video Demonstrations</a></li>
    </ul>
  </div>
</div>

<div class="row mt-3">
  <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
  <h4>LENS: Neurofeedback</h4>
  <ul>
    <li><a href="https://ochslabs.com/" target="_blank">LENS Information (Ochs Labs) on YouTube</a></li>
    <li><a href="https://ochslabs.com/how-lens-works/" target="_blank">Discover How LENS Works</a></li>
    <li><a href="https://ochslabs.com/benefits-of-lens/" target="_blank">Understand How LENS May Benefit Your Healing Journey</a></li>
  </li>
  </ul>
  </div>
  <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
 <h4>ACT (Acceptance and Commitment Therapy)</h4>
  <ul>
    <li><a href="https://contextualscience.org/" target="_blank">Association for Contextual Behavioral Science (ACBS)</a></li>
    <li><a href="https://thehappinesstrap.com/free-resources/" target="_blank">Free ACT Resources by Dr. Russ Harris</a></li>
    <li><a href="https://stevenchayes.com/tools/" target="_blank">ACT Tools by Steven C. Hayes</a></li>
  </li>
  </ul>
  </div>
</div>
<div class="row mt-3">
  <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
  <h4>MI (Motivational Interviewing)</h4>
  <ul>
    <li><a href="https://motivationalinterviewing.org/" target="_blank">Motivational Interviewing Network of Trainers (MINT)</a></li>
    <li><a href="https://psychwire.com/free-resources/motivational-interviewing" target="_blank">Motivational Interviewing Resources on Psychwire</a></li>
    <li><a href="https://case.edu/socialwork/centerforebp/practices/motivational-interviewing/motivational-interviewing-resources
" target="_blank">Motivational Interviewing Resources at the Center for Evidence-Based Practices:</a></li>
  </li>
  </ul>
  </div>
 <div class="col-12 col-sm-12 col-md-12 col-lg-6 ">
  <h4>Resources</h4>
  <ul>
    <li><a href="https://www.gottman.com/about/research/" target="_blank">Gottman</a></li>
    <li><a href="https://positivepsychology.com/family-therapy-techniques/" target="_blank">Positive Psychology</a></li>
    <li><a href="https://www.carepatron.com/resources/family-counselor" target="_blank">Carepatron</a></li>
  </li>
  </ul>
  </div>
</div>

<div class="row mt-4">
  <div class="col-12 col-sm-12 col-md-12 col-lg-12 mt-3">

<h4>Crisis and Support Hotlines</h4>
<ol>
  <li><strong>National Suicide Prevention Lifeline</strong>: Call <strong>1-800-273-8255</strong> for free, confidential, 24/7 support for individuals in distress, as well as prevention and crisis resources.</li>
<li><strong>Crisis Text Line</strong>: Text <strong>HOME</strong> to <strong>741741</strong> to connect with a trained crisis counselor 24/7.</li>
<li><strong>SAMHSA (Substance Abuse and Mental Health Services Administration)</strong>: Call <strong>1-800-662-HELP (4357)</strong> for free, confidential assistance with substance use and mental health resources.</li>
<li><strong>NAMI (National Alliance on Mental Illness)</strong>: Call <strong>1-800-950-NAMI (6264)</strong> for support and information, available Monday through Friday, 10 a.m.–10 p.m. ET.</li>
<li><strong>Veterans Crisis Line</strong>: Call <strong>1-800-273-8255</strong>, press <strong>1</strong>, or text <strong>838255</strong> to connect with VA responders.</li>
<li><strong>National Domestic Violence Hotline</strong>: Call <strong>1-800-799-SAFE (7233)</strong> or TTY <strong>1-800-787-3224</strong> for confidential support.</li>
<li><strong>Childhelp National Child Abuse Hotline</strong>: Call <strong>1-800-4-A-CHILD (1-800-422-4453)</strong> for prevention and support.</li>
<li><strong>ElderCare Locator</strong>: Call <strong>1-800-677-1116</strong> for services supporting older adults and caregivers.</li>
<li><strong>National Eating Disorders Association (NEDA) Helpline</strong>: Call <strong>1-800-931-2237</strong> for eating disorder resources and support.</li>
<li><strong>RAINN (Rape, Abuse & Incest National Network)</strong>: Call <strong>1-800-656-HOPE (4673)</strong> for survivors of sexual assault.</li>
<li><strong>The Trevor Project</strong>: Call <strong>1-866-488-7386</strong> for LGBTQ+ youth crisis intervention and suicide prevention.</li>
<li><strong>Trans Lifeline</strong>: Call <strong>1-877-565-8860</strong> for support for transgender individuals in crisis.</li>
<li><strong>National Parent Helpline</strong>: Call <strong>1-855-4A-PARENT (1-855-427-2736)</strong> for parenting support.</li>
<li><strong>Al-Anon Family Groups</strong>: Call <strong>1-888-4AL-ANON (1-888-425-2666)</strong> for families affected by someone else’s drinking.</li>
<li><strong>GriefShare</strong>: Visit GriefShare for grief support groups and resources.</li>
<li><strong>211 Helpline</strong>: Call <strong>211</strong> for referrals to community resources, including mental health services.</li>
<li><strong>Boys Town National Hotline</strong>: Call <strong>1-800-448-3000</strong> for youth and family crisis support.</li>
<li><strong>Partnership to End Addiction</strong>: Call <strong>1-855-378-4373</strong> for guidance on substance abuse issues.</li>
<li><strong>Samaritans USA</strong>: Call <strong>1-212-673-3000</strong> for emotional support and crisis response.</li>
<li><strong>Postpartum Support</strong>: Call <strong>1-800-944-4773</strong> for postpartum mood disorder support.</li>
<li><strong>Addiction Hotline</strong>: Call <strong>1-877-226-3111</strong> for addiction-related assistance.</li>
<li><strong>Eating Disorder Hotline</strong>: Call <strong>1-844-228-2962</strong> for eating disorder support.</li>
<li><strong>Self-Harm Hotline</strong>: Call <strong>1-877-455-0628</strong> for self-harm support.</li>
<li><strong>Depression Hotline</strong>: Call <strong>1-888-640-5147</strong> for depression-related assistance.</li>
<li><strong>Gambling and Video Game Addiction Hotline</strong>: Call <strong>1-800-GAMBLER (426-2537)</strong> for addiction resources.</li>

</li>


</ol>

<p class="my-5">Please get in touch with us if you want further resources, guidance, or information about our services.</p>
           

  </div>
</div>
 
 

 
      </div>
    </section>
 
 
<?php include('_request-an-appointment.php');?>
<?php include('footer.php');?>