<?php include('header.php');?>
    <link rel="stylesheet" href="./css/hero.css" />
    <link rel="stylesheet" href="./css/retreat.css" />
    <section class="main-hero">
      <section aria-label="main" class="hero retreat" id="main">
        <div class="bg-overlay"></div>
        <div class="hero-description wow animated bounceInLeft">
          <h3>Renew Retreat for Therapists and Practitioners</h3>
          <h4>Meet YOU in PERU</h4>
          <h4>June 16–20, 2025 or More!</h4>
          <h3>Empower. Renew. Transform.</h3>
          <p>Hosted by Renew Psychotherapy Center, LLC</p>
          <a href="https://buy.stripe.com/dR602r6Fm2ci90YcMO" class="button">Sign me Up!</a>
        </div>
      </section>
    </section>
    <section class="ochs-labs">
      <div class="container">
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <h3 class="skyblue text-center">Your Adventure Starts Here</h3>
            <p>
              Join us for an incredible 5-day, 4-night retreat at the stunning
              Beach El Peñascal in San Bartolo, Peru. Here, breathtaking
              landscapes blend seamlessly with rich cultural experiences to
              provide a transformative getaway.
            </p>
            <h3 class="skyblue text-center">Retreat Highlights</h3>
            <ul>
              <li class="mb-3">
                <strong>Barranco and Costa Verde</strong>: Discover Lima’s
                vibrant artistic district, renowned for its bohemian charm and
                creative atmosphere.
              </li>
              <li class="mb-3">
                <strong>Miraflores & South Beaches</strong>: Savor scenic ocean
                views and enjoy leisurely walks along picturesque trails.
              </li>
              <li class="mb-3">
                <strong>Paracas National Reserve</strong>: Encounter diverse
                wildlife and marvel at Peru’s natural beauty.
              </li>
              <li class="mb-3">
                <strong>Pachacamac Ruins and Hacienda Secrets</strong>: Delve
                into ancient secrets at this fascinating archaeological site,
                followed by a visit to a prestigious hacienda.
              </li>
            </ul>
                        
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <img src="./images/retreat-your-adventure.jpg" class="img-fluid" alt="" />
          </div>
        </div>
      </div>
    </section>
    <section>
      <div class="container">
        <div class="row">
          <div class="col-12 text-center">
            <hr class="mb-5" />
            <h4 class="skyblue pb-1">
              Optional Extra Night or Extended Peru Adventure
            </h4>
            <h5 class="">
              Imagine Learning, Relaxing, and Thriving in Harmony
            </h5>
            <h4 class="skyblue">Extended Peru Experience: June 21–25, 2025 or More!</h4>
            <p>
              Elevate your retreat with an extraordinary journey through Peru’s
              most iconic destinations. This once-in-a-lifetime adventure blends
              cultural exploration, breathtaking landscapes, and unforgettable
              experiences.
            </p>
            <hr class="my-5"/>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
          <img
            src="./images/retreat-machu-picchu.jpg"
            class="img-fluid"
          />
          </div>
        </div>
        </div>
    </section>    
    <section class="background-degrade">
       <div class="container">
        <div class="row mt-5">
          <div
            class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center"
          >
            <h3>Itinerary Highlights</h3>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4">
            <div class="d-flex align-items-center">
              <img
                src="./images/retreat-hightlight-cusco.jpg"
                width="300"
                class="circle"
              />
            </div>
            <h4 class="skyblue text-center">
              Cusco, Sacred Valley & Machu Picchu
            </h4>
            <ul class="type-circle">
              <li>
                <strong>Cusco</strong>: Immerse yourself in the city’s rich
                history and take a day trip to the vibrant Rainbow Mountains.
              </li>
              <li>
                <strong>Sacred Valley</strong>: Explore breathtaking landscapes
                and connect with Peru’s vibrant culture.
              </li>
              <li>
                <strong>Machu Picchu</strong>: Embark on scenic hikes and
                witness the awe-inspiring Inca masterpiece.
              </li>
            </ul>
            <!--<a href="javascript:void()" class="button is-fifty mr-0 mb-5"
              >Show More
              <div>+</div></a
            >-->
          </div>

          <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4">
            <div class="d-flex align-items-center text-center">
              <img
                src="./images/retreat-hightlight-inti-raymi.jpg"
                class="circle"
              />
            </div>
            <h4 class="skyblue text-center">Inti Raymi <br />Festival</h4>
            <ul class="type-circle">
              <li>
                Experience the annual Festival of the Sun, a traditional Inca
                celebration in Cusco (June 24, 2025).
              </li>
            </ul>
            <!--<a href="javascript:void(0)" class="button is-fifty mr-0 mb-5"
              >Show More
              <div>+</div></a
            >-->
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4">
            <div class="d-flex align-items-center text-center">
              <img
                src="./images/retreat-hightlight-puno.jpg"
                class="circle"
              />
            </div>
            <h4 class="skyblue text-center">Puno & Uros <br />Islands</h4>
            <ul class="type-circle">
              <li>
                <strong>Puno</strong>: Adjust to the high altitude and explore
                this enchanting city (1 day).
              </li>
              <li>
                <strong>Uros Islands</strong>: Visit the floating islands on
                Lake Titicaca and engage with their unique cultural heritage.
              </li>
            </ul>
            <!--<a href="javascript:void(0)" class="button is-fifty mr-0 mb-5"
              >Show More
              <div>+</div></a
            >-->
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2"></div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4">
            <div class="d-flex align-items-center">
              <img
                src="./images/retreat-hightlight-arequipa.jpg"
                class="circle"
              />
            </div>
            <h4 class="skyblue text-center">Arequipa & <br />Colca Valley</h4>
            <ul class="type-circle">
              <li>
                <strong>Arequipa</strong>: Wander through the city’s charming
                historic center, known for its unique white volcanic stone
                architecture.
              </li>
              <li>
                <strong>Colca Valley</strong>: Marvel at Andean condors and the
                breathtaking beauty of one of the world’s deepest canyons.
              </li>
            </ul>
            <!--<a href="javascript:void(0)" class="button is-fifty mr-0 mb-5"
              >Show More
              <div>+</div></a
            >-->
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-4 col-xl-4">
            <div class="d-flex align-items-center">
              <img
                src="./images/retreat-hightlight-amazon.jpg"
                class="circle"
              />
            </div>
            <h4 class="skyblue text-center">
              Peruvian Amazon: Tambopata National Reserve and Manu National Park
            </h4>
            <ul class="type-circle">
              <li>
                Discover the heart of the <strong>Peruvian Amazon</strong> and
                immerse yourself in unparalleled biodiversity, serene
                tranquility, and the magic of the rainforest.
              </li>
            </ul>
            <!--<a href="javascript:void(0)" class="button is-fifty mr-0 mb-5"
              >Show More
              <div>+</div></a
            >-->
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2"></div>
        </div>
      </div>
    </section>

    <section class="ochs-labs">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h4 class="skyblue text-center">Reserve Your Spot Today</h4>
            <p>
              A dedicated Peru coordinator will assist with planning every
              detail, ensuring a seamless and well-organized experience. Let us
              create an exceptional travel experience in partnership with
              trusted tourism professionals. Don’t miss this opportunity to
              renew, explore, and create lifelong memories in Peru!
            </p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-oceanfront.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Oceanfront Serenity</h4>
            <p>
              <strong>4 nights and 5 days</strong> in tranquil accommodations
              with infinity pools and private beach access.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-workshops.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Inspiring Workshops</h4>
            <p>
              Covering
              <strong>EMDR, ART, CBT, DBT, Eco-Art, Sand Therapy</strong>, and
              more.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-education.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Continuing Education Credits</h4>
            <p>
              <strong>CE's</strong> and <strong>EMDRIA</strong><br> certifications
              provided.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-interactive.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Interactive Learning</h4>
            <p>
              Engage in lectures, role-playing, case studies, and mindfulness
              workshops.
            </p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-outdoor.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Outdoor Activities</h4>
            <p>
              Enjoy <strong>hiking, swimming, surfing, paddleboarding</strong>,
              and <strong>more</strong>.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-creative.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Creative Expression</h4>
            <p>
              <strong>Arts, crafts, journaling</strong>, and
              <strong>inspired writing activities</strong>.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-equestrian.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Equestrian Experiences</h4>
            <p>
              <strong>Horseback riding</strong> and
              <strong>animal-assisted therapy</strong>.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-mindfulness.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Mindfulness Practices</h4>
            <p>
              <strong>Daily yoga, breathwork</strong>, and
              <strong>meditation sessions</strong>.
            </p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-gourmet.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Gourmet Cuisine</h4>
            <p>
              <strong
                >Meals crafted by professional chefs blending local</strong
              >
              and <strong>international flavors</strong>.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-sound.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Sound Baths & Ceremonies</h4>
            <p>
              Participate in <strong>traditional Peruvian rituals</strong> for
              <strong>renewal</strong> and <strong>connection</strong>.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-networking.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Networking Opportunities</h4>
            <p>
              Build <strong>meaningful</strong> and
              <strong>lasting professional</strong> relationships.
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 text-center">
            <div class="step-circle d-flex align-items-center">
              <img
                src="./images/retreat-reserve-transport.png"
                class="img-arrow"
              />
            </div>
            <h4 class="skyblue text-center">Complimentary Airport Transfers</h4>
            <p>
              Relax with <strong>thoughtfully</strong> arranged group
              transportation.
            </p>
          </div>
        </div>

        <div class="row mt-5">
          <div class="col-12">
            <h4 class="skyblue text-center">Welcome Gifts and So Much More!</h4>
            <p>
              From surprise welcome bags to unparalleled experiences, your path
              to renewal and transformation begins here
            </p>
          </div>
        </div>
        <hr />
        <div class="row mt-5">
          <div class="col-12 text-center">
            <h4 class="skyblue pb-1">Retreat Curriculum Overview</h4>
            <p class="skyblue">
              <strong>
                Trauma-Informed Care: The Science of Connection and Healing with
                Purpose for Children, Teens, Adults, and Families</strong
              >
            </p>
            <p class="my-5">
              The curriculum provides an in-depth exploration of trauma’s
              neurological impact across developmental stages. Participants will
              engage in diverse, evidence-based therapeutic techniques,
              including:
            </p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6">
            <ul>
              <li>
                <strong>EMDR therapy’s</strong> comprehensive 8-phase protocol
              </li>
              <li>
                <strong>Accelerated Resolution Therapy (ART)</strong> for quick
                trauma healing
              </li>
              <li>
                <strong>CBT and DBT</strong> for enhanced emotional balance and
                behavioral change
              </li>
              <li>
                <strong>Art Therapy</strong> to access and process deep
                emotional experiences
              </li>
            </ul>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-6">
            <ul>
              <li>
                <strong>Eco-Art, Sand Therapy, LENS Neurofeedback</strong> and
                much more
              </li>
              <li>
                <strong>Somatic Yoga</strong> for holistic mind-body connection
              </li>
              <li>
                <strong
                  >Cultural Competence, Vicarious Trauma and Ethical
                  Practices</strong
                >
              </li> 
            </ul>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-center my-4">
            <p>
              Key topics cover polyvagal theory, sensory integration, and
              innovative approaches for promoting stability, resilience, and
              recovery. Advanced strategies tackle complex challenges with a
              deep focus on compassionate and ethical care. The program
              integrates caregiver participation, equipping practitioners with
              actionable tools to support grounding and regulation for
              individuals and families.
            </p>
            <h4 class="skyblue">
              Experience Renewal, Connection, and Transformation in the Heart of
              Peru.
            </h4>
            <a
              href="what-we-offer.html"
              class="button is-sixty animated bounceInLeft"
              ><div>&gt;</div>
              <span>Learn More</span></a
            >
            <hr class="mt-5" />
          </div>
        </div>

     </div>
     </section>
     <section class="background-degrade">
<div class="container">
        <div class="row">
          <div
            class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center"
          >
            <h3>YOUR SPEAKERS AND EXPERT PANEL</h3>
            <h4 class="skyblue">
              Meet your Charismatic Hosts, Motivational Speakers, and Presenters
            </h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2"></div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 block-cards">
            <card class="with-icons">
              <img src="./images/emdria-2.png" />
              <img src="./images/emdria-1.png" />
              <img src="./images/team-linda-timme.png" />
              <div class="text">
                <h3 class="text-center">Dr. Linda Timme</h3>
                <p>
                  Dr. Linda is a transformational leader and a passionate
                  advocate for global wellness, dedicated to holistic mental
                  health care. With over 15 years of experience, she has helped
                  countless individuals through her innovative therapeutic
                  approaches, immersive retreats, and professional development
                  programs.
                </p>
                <a href="#modalDrLindaTime" class="button is-fifty" data-bs-toggle="modal" href="#modalDrLindaTime" role="button"
                  >Show More
                  <div>+</div></a
                >
                
              </div>
            </card>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-1 col-xl-1"></div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3 block-cards">
            <card>
              <img src="./images/team-david-timme-2.png" />
              <div class="text">
                <h3 class="text-center">David Timme</h3>
                <p>
                  David Timme is a beloved Physician Assistant with over 45
                  years of experience in psychiatry. He is truly dedicated to
                  enhancing mental health care and provides warm, evidence-based
                  treatment to people from all walks of life. With a rich
                  background in community mental health, private practice, and
                  innovative psychiatric care, David is a trusted presence in
                  his field.
                </p>
                <a href="#modalDrDavidTime" class="button is-fifty" data-bs-toggle="modal" role="button"
                  >Show More
                  <div>+</div></a
                >
              </div>
            </card>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2"></div>
        </div>
      </div>
    </section>
    <section>
      <div class="container">
        <div class="row">
          <div class="col-12 text-center">
            <h3>Keynote Speaker, Partnership, and Agenda Overview</h3>
          </div>
        </div>
        <div class="row mb-5">
          <div class="col-12 d-flex justify-content-xl-end justify-content-lg-end">
            <card class="reverse left">
              <div class="text">
                <h3>Dr. Cio Hernández</h3>
                <p>
                  Dr. Cio Hernández is CEO and founder of Got This! Inc. and The
                  Be It Foundation. She is a psychotherapist in California,
                  Texas, and Hawaii where she specializes in goal-getting,
                  anxiety, relationships, safety through connection, childhood
                  and trauma. In her private practice, she offers EMDR and other
                  modalities to replace haunting memories with a new outlook on
                  life or to help people reach a positive life goal...
                </p>
                <a href="#modalDrCio" class="button is-fifty" data-bs-toggle="modal" role="button"
                  >Show More
                  <div>+</div></a
                >
              </div>
              <img src="./images/speaker-cio-hernandez.png" />
            </card>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-center">
            <h3>Presenters & Agenda Overview</h3>
          </div>
        </div>
        <div class="row mb-5">
          <div class="col-12 ">
            <card class="reverse right">
              <img src="./images/speaker-frances-klaff.png" />
              <div class="text">
                <h3>Dr. Frances Klaff</h3>
                <p>
                  Frances (Frankie) Klaff Ph.D is a clinical psychologist with
                  over fifty years of experience in practice, both as a
                  therapist and teacher/trainer. Her expertise in EMDR dates to
                  its beginning, teaching and facilitating with EMDR’S creator,
                  Dr. Francine Shapiro, at the EMDR Institute where she is still
                  senior faculty. She is also a certified EMDRIA consultant and
                  faculty for HAP, the humanitarian branch of EMDR.
                </p>
                <a href="#modalDrFrances" class="button is-fifty" data-bs-toggle="modal" role="button"
                  >Show More
                  <div>+</div></a
                >
              </div>
            </card>
          </div>
        </div>
        
 <div class="row mb-5">
          <div class="col-12 d-flex justify-content-end">
            <card class="reverse left">
              <img src="./images/speaker-sarita-molinar.png" />
              <div class="text">
                <h3>Sarita Molinar, LPC, Art Therapist, EYT-200</h3>
                <p>
                  Sarita Molinar is an integrative mental health professional who strives to combine therapeutic modalities in a creative and holistic way.  Her experience in education, art therapy, and yoga have allowed her to apply, first hand, the techniques that bring flow to self-discovery in herself and her clients. 
                </p>
                <a href="#modalSarita" class="button is-fifty" data-bs-toggle="modal" role="button"
                  >Show More
                  <div>+</div></a
                >
              </div>
            </card>
          </div>
        </div>
        <hr class="mb-5" />
        <div class="row">
          <div class="col-12 text-center">
            <h3>Program & Schedule Overview</h3>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <h4 class="skyblue">Day 1: Arrival and Intention Setting</h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <p>
              <strong>3:00 PM</strong>: Shared transport to Lima for your arrival and relaxation.
            </p>
            <p>
              <strong>6:00 PM</strong>: Group dinner with beach relaxation and mindfulness under the Peruvian sky.
            </p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <h4 class="skyblue">
              Days 2–4: Immersive Wisdom, Connection, and Networking
            </h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <p><strong>7:00 AM</strong>: Beach yoga and meditation.</p>
            <p><strong>8:00 AM</strong>: Breakfast.</p>
            <p><strong>9:00 AM</strong>: Workshops.</p>
            <p><strong>1:00 PM</strong>: Lunch.</p>
            <p>
              <strong>2:00 PM</strong>: Free time and afternoon activities,
              including:
            </p>
            <ul class="mx-4">
              <li>Excursions and coastal exploration.</li>
              <li>
                Experiential workshops on innovations like Bilateral Stimulation
                (BLS).
              </li>
              <li>Nervous system regulation with nature.</li>
              <li>Somatic healing practices.</li>
              <li>
                Creativity and connection rituals using natural materials.
              </li>
              <li>
                Mindful movement and a plant essence ceremony with a local
                healer.
              </li>
              <li>
                Discover the synergy of growth, culture, and connection in the
                heart of Peru.
              </li>
              <li>Optional spa time.</li>
              <li>Live music and game night!</li>
            </ul>
            <p><strong>7:00 PM</strong>: Dinner.</p>
            <p>
              <strong>8:00 PM</strong>: Evening reflection and group sharing,
              closing with intention-setting rituals.
            </p>
          </div>
        </div>

        <div class="row">
          <div class="col-12 text-start">
            <h4 class="skyblue">
              Day 5: Reflection, Departure, or Extended Exploration
            </h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <ul class="mx-4">
              <li>
                <strong>Morning:</strong> Shared transport back to Lima for your onward journey.
              </li>
              <li>
                <strong>Optional Extra Day:</strong> Stay an additional night and join guided
                tours.
              </li>
              <li>
                <strong>Group Travel Planning & Adventure Awaits:</strong> Explore iconic destinations like:
                <ul class="mt-3">
                  <li>Machu Picchu.</li>
                  <li>Rainbow Mountains.</li>
                  <li>Arequipa.</li>
                  <li>Lake Titicaca.</li>
                  <li>
                    Manu and Tambopata National Reserve in the Peruvian Amazon,
                    offering lush biodiversity and tranquility.
                  </li>
                </ul>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </section>

    <section class="background-degrade">
      <div class="container">
        <hr class="mb-5" />
        <div class="row">
          <div class="col-12 text-center">
            <h4 class="skyblue">Renew Retreat Investment & Venue</h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <p>
              <strong class="skyblue">For Registrations:</strong> The costs include all-inclusive retreat benefits from June 16–20, 2025.
            </p>
            <p>
              <strong class="skyblue">Optional Extra Days:</strong> Elevate your experience by extending your stay with additional nights and guided tours—available at your own expense.
            </p>
            <p>Choose from several room options and flexible payment plans. Picture yourselves with us and reserve your spots today!</p>
          </div>
        </div>
        <hr class="mb-5" />
        <div class="row">
          <div class="col-12 text-start">
            <h4 class="skyblue pb-0">Retreat Packages</h4>
            <h4>Starting at $2,500</h4>
          </div>
        </div>
        <div class="row">
          <div class="description">
            <div class="item mb-5">
              <div class="row">
                <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                  <div class="text">
                    <h4 class="skyblue pb-1">Ocean View Master Room</h4>
                    <ul class="mb-1">
                      <li class="mb-0"><strong>Investment</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li>Single Participant: $3,500 USD</li>
                        </ul>
                    <ul class="mb-1">
                      <li class="mb-0"><strong>Details</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li><img src="./images/icon-bed.png" class="border-0 rounded-0 shadow-none d-inline mx-3">King-size bed with ocean view</li>
                          <li><img src="./images/icon-bath.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Ensuite private bath with shower</li>
                          <li><img src="./images/icon-man.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Single or couples occupancy</li>
                          </li>
                        </ul>
                  </div>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                  <img
                    src="./images/retreat-ocean-view-master-room-2.png"
                    class="img-fluid border-0"
                    alt
                  />
                </div>
              </div>
            </div>
            <div class="item mb-5">
              <div class="row">
                   <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                  <img
                    src="./images/retreat-ocean-view-terraza-3.jpg"
                    class="img-fluid border-0 border-left"
                    alt
                  />
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                  <div class="text">
                    <h4 class="skyblue pb-2">Balcony Ocean View Master Room</h4>
                    <ul>
                      <li ><strong>Investment</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li>Single Participant: $3,000 USD</li>
                        </ul>
                    <ul>
                      <li><strong>Details</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li><img src="./images/icon-bed.png" class="border-0 rounded-0 shadow-none d-inline mx-3">King-size bed with ocean view</li>
                          <li><img src="./images/icon-bath.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Private bath with shower</li>
                          <li><img src="./images/icon-man.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Single or couples occupancy</li>
                        </ul>

                        <h4 class="skyblue pb-2">Balcony Ocean View Room</h4>
                    <ul>
                      <li ><strong>Investment</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li>Single Participant: $3,000 USD</li>
                          <li>Double Occupancy Participants: Pay</li>
                        </ul>
                    <ul>
                      <li><strong>Details</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li><img src="./images/icon-bed.png" class="border-0 rounded-0 shadow-none d-inline mx-3">One single bed</li>
                          <li><img src="./images/icon-sofa-bed.png" class="border-0 rounded-0 shadow-none d-inline mx-3">One sofa bed</li>
                          <li><img src="./images/icon-bath.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Shared bath</li>
                        </ul>
                  </div>
                </div>
             
              </div>
            </div>
 
            <div class="item mb-5">
              <div class="row">
                <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                  <div class="text">
                    <h4 class="skyblue pb-1">Shared Room (Shared Bath)</h4>
                    <ul class="mb-1">
                      <li class="mb-0"><strong>Investment</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li>Single Participant: $2,500 USD</li>
                        </ul>
                    <ul class="mb-1">
                      <li class="mb-0"><strong>Details</strong>
                      </li>
                    </ul>
                    <ul class="reverse">
                          <li><img src="./images/icon-bed.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Single bed</li>
                          <li><img src="./images/icon-sofa-bed.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Sofa bed</li>
                          <li><img src="./images/icon-double-bed.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Double bed or twin beds</li>
                          <li><img src="./images/icon-group-travelers.png" class="border-0 rounded-0 shadow-none d-inline mx-3">Group travelers share a bath</li>
                          </li>
                        </ul>
                  </div>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                  <img
                    src="./images/retreat-ocean-view-room-3.jpg"
                    class="img-fluid border-0"
                    alt
                  />
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
<section>
     
<div class="container">
  <div class="row">
 <div class="col-12 text-center">
   <h3 class="mt-0 mb-4">Soulful RENEW Center</h1> 
 </div>                     
</div>

  <div class="row text-center text-lg-start">

    <div class="col-lg-3 col-md-4 col-6">
      <a href="./images/location/DSC05114.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05114">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05114.png" alt="DSC05114">
      </a>
    </div>
    <div class="col-lg-3 col-md-4 col-6">
      <a href="./images/location/DSC05120.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05120">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05120.png" alt="DSC05120">
      </a>
    </div>
    <div class="col-lg-3 col-md-4 col-6">
      <a href="./images/location/DSC05140.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05140">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05140.png" alt="DSC05140">
      </a>
    </div>
    <div class="col-lg-3 col-md-4 col-6">
     <a href="./images/location/DSC05198.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05198">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05198.png" alt="DSC05198">
      </a>
    </div>
    <div class="col-lg-3 col-md-4 col-6">
      <a href="./images/location/DSC05227.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05227">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05227.png" alt="DSC05227">
      </a>
    </div>
    <div class="col-lg-3 col-md-4 col-6">
      <a href="./images/location/DSC05259.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05259">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05259.png" alt="DSC05259">
      </a>
    </div>
    <div class="col-lg-3 col-md-4 col-6">
      <a href="./images/location/DSC05290.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05290">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05290.png" alt="DSC05290">
      </a>
    </div>
    <div class="col-lg-3 col-md-4 col-6">
      <a href="./images/location/DSC05343.png" class="d-block mb-4 h-100" data-fancybox="gallery" data-caption="DSC05343">
        <img class="img-fluid img-thumbnail" src="./images/location/thumbnails/DSC05343.png" alt="DSC05343">
      </a>
    </div>
    
    <hr class="my-5" />
  </div>
  
</div>

</section>
<section class="pt-2">
  <div class="container">
        <div class="row">
          <div class="col-12 text-center">
            <h4 class="skyblue">Special Discounts</h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-center">
            <p>
              <strong class="skyblue">Early Lovebirds:</strong> $150 off for the
              first <strong>six participants</strong>
            </p>
            <p>
              <strong class="skyblue">Group Discount:</strong> $200 off for
              groups of <strong>four or more</strong>
            </p>
            <p>
              <strong class="skyblue">Community Support:</strong> $300 off for
              underrepresented communities or past retreat attendees
            </p>
          </div>
        </div>
        <hr />
        <div class="row mt-5">
          <div class="col-12 text-center">
            <h4 class="skyblue">Location and Venue</h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <p class="text-center">
              <strong>Ocean Reef at Beach El Peñascal</strong> offers stunning,
              all-inclusive accommodations in a serene coastal retreat.
              Surrounded by the beauty of the <strong>Pacific Ocean</strong>,
              it’s the perfect setting for reflection, renewal, and connection.
            </p>
            <h4 class="skyblue">Amenities:</h4>
            <ul>
              <li>Infinity pools with panoramic ocean views</li>
              <li>Fitness center and relaxing sauna/spa facilities</li>
              <li>Playground, game rooms, and on-site dining</li>
              <li>Private beach access for ultimate tranquility</li>
            </ul>
          </div>
        </div>
        <hr />
        <div class="row mt-5">
          <div class="col-12 text-center">
            <h4 class="skyblue">Frequently Asked Questions</h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
            <div class="accordion" id="accordionExample">
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse1"
                    aria-expanded="true"
                    aria-controls="collapse1"
                  >
                    Who is the ideal target audience for this retreat?
                  </button>
                </h2>
                <div
                  id="collapse1"
                  class="accordion-collapse collapse show"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>This retreat is designed for:</p>
                    <ul>
                      <li>
                        <strong>Psychologists, licensed therapists</strong>, and
                        <strong>mental health professionals</strong> looking to
                        deepen their practice.
                      </li>
                      <li>
                        <strong>Social workers, educators</strong>, and
                        <strong>community leaders</strong> dedicated to serving
                        <strong>trauma-affected populations</strong>.
                      </li>
                      <li>
                        <strong>Healthcare providers</strong>, including
                        <strong>physicians</strong> and <strong>nurses</strong>,
                        seeking advanced skills in
                        <strong>trauma-informed care</strong>.
                      </li>
                      <li>
                        <strong>Life coaches, practitioners, healers</strong>,
                        and <strong>spiritual counselors</strong> expanding
                        their <strong>expertise in holistic approaches</strong>.
                      </li>
                      <li>
                        <strong>Professionals in leadership roles</strong> who
                        aim to integrate wellness and trauma-informed practices
                        into their work.
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse2"
                    aria-expanded="false"
                    aria-controls="collapse2"
                  >
                    Do I need a passport?
                  </button>
                </h2>
                <div
                  id="collapse2"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      Yes, a valid passport is required for this trip. If you
                      don’t have one yet, we highly recommend applying as soon
                      as possible, as current processing times can take several
                      weeks.
                    </p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse3"
                    aria-expanded="false"
                    aria-controls="collapse3"
                  >
                    Is this retreat suitable for solo travelers?
                  </button>
                </h2>
                <div
                  id="collapse3"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      Absolutely! Our retreat is designed to support personal
                      growth and provide opportunities to build meaningful
                      connections. Solo travelers will feel welcomed and
                      encouraged to engage with like-minded individuals,
                      fostering a sense of community within the therapist
                      network.
                    </p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapseFor"
                    aria-expanded="false"
                    aria-controls="collapseFor"
                  >
                    How do I get to the retreat location?
                  </button>
                </h2>
                <div
                  id="collapseFor"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      You will fly into Jorge Chávez International Airport (LIM)
                      in Lima, Peru. Please ensure your flight arrives before
                      13:00 PM on June 16. Our team will provide detailed
                      instructions on transportation options to the venue. Group
                      shuttles or private transfers can be arranged to ensure a
                      smooth journey.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapseFive"
                    aria-expanded="false"
                    aria-controls="collapseFive"
                  >
                    Do I need to know the Spanish language?
                  </button>
                </h2>
                <div
                  id="collapseFive"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      It’s not necessary to know Spanish. You will learn a few
                      essential words and phrases during the retreat, which can
                      enhance your experience. Our staff speaks fluent English,
                      so communication won’t be an issue.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapseSix"
                    aria-expanded="false"
                    aria-controls="collapseSix"
                  >
                    Can I bring a guest?
                  </button>
                </h2>
                <div
                  id="collapseSix"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      Your guest is welcome to fully participate in the retreat
                      experience, making it a memorable journey for both of you.
                      If you plan to bring a guest, please email us with their
                      name so we can ensure you are booked in the same room.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapseSeven"
                    aria-expanded="false"
                    aria-controls="collapseSeven"
                  >
                    Can I bring my children and family?
                  </button>
                </h2>
                <div
                  id="collapseSeven"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      We understand the desire to share this fantastic
                      experience with your family! We can help plan a family
                      meet-up either before or after the retreat. It’s a great
                      opportunity to explore the area and enjoy the breathtaking
                      scenery together.
                    </p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse9"
                    aria-expanded="false"
                    aria-controls="collapse9"
                  >
                    Is there a daily schedule for the retreat?
                  </button>
                </h2>
                <div
                  id="collapse9"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      Yes! We understand the importance of having a structured
                      plan to help you prepare. A detailed itinerary will be
                      provided before the retreat.
                    </p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse10"
                    aria-expanded="false"
                    aria-controls="collapse10"
                  >
                    Where is the retreat located?
                  </button>
                </h2>
                <div
                  id="collapse10"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      Our retreat takes place at the stunning venue in the heart
                      of San Bartolo, Peru. This serene location offers the
                      perfect blend of comfort and natural beauty for an
                      unforgettable experience.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse11"
                    aria-expanded="false"
                    aria-controls="collapse11"
                  >
                    What expenses are not covered?
                  </button>
                </h2>
                <div
                  id="collapse11"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      The following expenses are not included in the cost of the
                      retreat:
                    </p>

                    <ul>
                      <li>Airfare to and from Lima, Peru</li>
                      <li>Individual transportation to and from the retreat</li>
                      <li>Tips and gratuities</li>
                      <li>Travel insurance</li>
                      <li>
                        Excursions or activities or extra nights outside the
                        group itinerary
                      </li>
                    </ul>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse12"
                    aria-expanded="false"
                    aria-controls="collapse12"
                  >
                    What is included in the price?
                  </button>
                </h2>
                <div
                  id="collapse12"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      The retreat includes accommodations, meals, group
                      activities, and select guided experiences. Additional
                      costs such as airfare, personal expenses, and optional
                      activities are not covered. Please refer to the
                      "All-Inclusive Retreat Benefits" section for a
                      comprehensive list.
                    </p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse13"
                    aria-expanded="false"
                    aria-controls="collapse13"
                  >
                    What is the cancellation and refund policy?
                  </button>
                </h2>
                <div
                  id="collapse13"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      You can cancel your retreat reservation and receive a full
                      refund, excluding the non-refundable deposit, if the
                      cancellation is made 150 days or more before the retreat
                      starts. The deposit is non-refundable unless the hosts
                      cancel the retreat. In the event of unforeseen
                      circumstances, a full refund will be provided.
                    </p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse14"
                    aria-expanded="false"
                    aria-controls="collapse14"
                  >
                    Should I rent a car?
                  </button>
                </h2>
                <div
                  id="collapse14"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      No need to rent a car! We provide group transportation to
                      and from the airport, ensuring a seamless and stress-free
                      start to your retreat experience.
                    </p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse15"
                    aria-expanded="false"
                    aria-controls="collapse15"
                  >
                    What is the benefit of joining the cancellation waitlist?
                  </button>
                </h2>
                <div
                  id="collapse15"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      We’ll notify you promptly if a cancellation opens up for
                      the trips you’re interested in.
                    </p>
                    <p class="font-weight-bold">
                      Important Details About the Retreat Terms and Conditions:
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse16"
                    aria-expanded="false"
                    aria-controls="collapse16"
                  >
                    Does Renew Psychotherapy Center cover airfare and personal
                    expenses?
                  </button>
                </h2>
                <div
                  id="collapse16"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      No, Renew Psychotherapy Center is not responsible for
                      flight changes, travel arrangements, or additional
                      personal expenses incurred by participants.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse17"
                    aria-expanded="false"
                    aria-controls="collapse17"
                  >
                    How can I file a complaint?
                  </button>
                </h2>
                <div
                  id="collapse17"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      Complaints must be submitted in writing to
                      admin@renewpsychotherapycenter.com. A response will be
                      provided within 5 to 10 business days.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse18"
                    aria-expanded="false"
                    aria-controls="collapse18"
                  >
                    Are there any conflicts of interest related to this
                    training?
                  </button>
                </h2>
                <div
                  id="collapse18"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      No, there are no conflicts of interest related to this
                      training.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse19"
                    aria-expanded="false"
                    aria-controls="collapse19"
                  >
                    Can I record sessions during the retreat?
                  </button>
                </h2>
                <div
                  id="collapse19"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      No, audio or video recording of sessions is strictly
                      prohibited.
                    </p>
                  </div>
                </div>
              </div>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button
                    class="accordion-button collapsed"
                    type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#collapse20"
                    aria-expanded="false"
                    aria-controls="collapse20"
                  >
                    Is the retreat location ADA accessible?
                  </button>
                </h2>
                <div
                  id="collapse20"
                  class="accordion-collapse collapse"
                  data-bs-parent="#accordionExample"
                >
                  <div class="accordion-body">
                    <p>
                      The retreat location is outside the U.S. and may not
                      comply with ADA accessibility standards.
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section>
      <div class="container">
        <hr />
        <div class="row mt-5">
          <div class="col-12 text-center">
            <h4 class="skyblue">What Are the Next Steps?</h4>
          </div>
        </div>
        <div class="row mb-5">
          <div class="col-12 col-sm-12 col-md-12 col-lg-2 col-xl-2"></div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3">
            <card class="step mb-4">
              <div class="step-circle-next d-flex align-items-center">
                <img src="./images/icon-next-step-1.png" />
              </div>
              <div class="text">
                <h3 class="text-start">Step 01:<br />Get in Touch</h3>
                <p>
                  Ready to explore more information about our retreats? Send us
                  an email, and I’ll respond within two business days. I’m
                  excited to help you start your journey!
                </p>
              </div>
            </card>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3">
            <card class="step mb-4">
              <div class="step-circle-next d-flex align-items-center">
                <img src="./images/icon-next-step-2.png" style="width:90px !important" />
              </div>
              <div class="text">
                <h3 class="text-start">Step 02:<br />Schedule a Chat</h3>
                <p>
                  Let’s connect! Book a call with me to share your goals and
                  discover how The Elevate Retreat can support your vision.
                </p>
                <br>
              </div>
            </card>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-3 col-xl-3">
            <card class="step">
              <div class="step-circle-next d-flex align-items-center">
                <img src="./images/icon-next-step-3.png" style="width:100px !important"/>
              </div>
              <div class="text">
                <h3 class="text-start">Step 03:<br />Save Your Spot</h3>
                <p>
                  Reserve your place in our next retreat and prepare for an
                  incredible experience filled with growth, connection, and
                  adventure!
                </p>
                <br>
              </div>
            </card>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-1 col-xl-1"></div>
        </div>
        <div class="row">
          <div class="col-12 text-center">
            <h4 class="skyblue">
              I look forward to helping you take the next steps toward an
              unforgettable journey!
            </h4>
            <h4>
              "Empower Your Practice. Renew Your Energy. Transform Your Life."
            </h4>
          </div>
        </div>
        <hr>
      </div>
    </section>
<section>
      <div class="container">
        <div class="row">
          <div class="col-12 text-center">
            <h4 class="skyblue">Spaces are limited—don’t miss this opportunity to transform your practice while immersing yourself in one of the world’s most beautiful destinations!</h4>
          </div>
        </div>
        </div>
        </section>

<div class="modal fade" id="modalDrLindaTime" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Dr. Linda Timme</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container">
          <section>
          <div class="row">
            <div class="col-12">
              <h4 class="title interiores"><span>Dr. Linda Timme</span></h4>
              <p>
                Dr. Linda is a transformational leader and a passionate advocate for global wellness, dedicated to holistic mental health care. With over 15 years of experience, she has helped countless individuals through her innovative therapeutic approaches, immersive retreats, and professional development programs.
</p>
<p>
                As a Certified EMDR Therapist, Advanced Trainer, and EMDRIA-approved Consultant, Dr. Linda specializes in trauma recovery, couples therapy, and organizational leadership. Her work blends evidence-based therapies like EMDR, CBT, DBT, and SFT to empower clients and clinicians to tackle complex challenges and create meaningful, lasting change.
</p>
<p>
                Dr. Linda's journey is truly inspiring. As a first-generation immigrant and dual citizen of the USA and Peru, she began her career as a psychologist in Peru, supporting Latinx and BIPOC/AAPI communities. After moving to the United States, she earned her Master’s and Clinical Social Work license and a Doctorate in Social Work: Leadership and Education. Her story embodies resilience and a deep commitment to enhancing mental health and wellness around the world.
</p>
<p>
                As a thought leader, Dr. Linda loves to foster growth and resilience in others. She organizes and leads wellness retreats, including her signature Global Renew Retreats, which provide transformative experiences combining advanced therapeutic training and personal renewal. These retreats focus on connection, professional development, and personal growth, featuring engaging workshops on modern modalities, mindfulness, eco-therapy, and leadership skills. She tailors her workshops to meet the unique needs of therapists, clinicians, and leaders, equipping them with valuable tools for both their personal and professional lives.
</p>
<p>
                Beyond her clinical and educational efforts, Dr. Linda is also an enthusiastic writer and researcher. She has shared her insights on telehealth, EMDR therapy, grief, and trauma recovery through various publications, and she is deeply committed to community and global wellness initiatives. Her contributions to the mental health field have earned her recognition, including the prestigious Candela Award.
</p>
<p>
                At the heart of Dr. Linda’s mission is a desire to inspire healing, resilience, and connection. She guides individuals and professionals toward greater well-being, purpose, and fulfillment. Whether through her therapeutic work, leadership programs, or uplifting retreats, Dr. Linda is dedicated to making a positive and lasting impact on the lives she touches and the communities she serves.

              </p>
            </div>
          </div>
          </section>
          <section class="mt-0 pt-4">
            <hr>
          <div class="row">
            <div class="col-12">
          
              <h3 class="text-center mt-5">Credentials and Achievements</h3>
        
              <h4 class="skyblue">Academic Qualifications</h4>
              <ul>
                <li><strong>Doctor of Social Work (DSW)</strong> – Leadership & Education, Millersville University</li>
                <li><strong>Master of Social Work (MSW)</strong> – Clinical Practice with Individuals and Families, Temple University</li>
              </ul>

<h4 class="skyblue mt-5">Professional Licenses and Certifications</h4>
<ul>
  <li><strong>Licensed Certified Social Worker-Clinical (LCSW-C)</strong> – Maryland</li>
  <li><strong>Licensed Clinical Social Worker (LCSW)</strong> – Pennsylvania & Virginia</li>
  <li><strong>Licensed Psychologist</strong>, clinical and organizational psychologist, University Federico Villarreal, Lima, Peru</li>
  <li>EMDR (Eye Movement Desensitization and Reprocessing) EMDR I and EMDR II, EMDR of Greater Washington, DC, 2017). I and EMDR 2, Washington, DC</li>
  <li>EMDR Certified Therapist by the EMDR International Association (EMDRIA)</li>
  <li>EMDRIA Approved Consultant (EAC) and Advanced Credit Provider</li>
  <li>EMDR 1 and EMDR 2 EMDR 3, Parnell Institute for EMDR, New York</li>
  <li>LENS Neurofeedback Certified, California</li>
  <li>Gottman Method Couples Therapy – Levels 1 and 2, The Gottman Institute</li>
</ul>


<h4 class="skyblue mt-5">Specialized Certifications</h4>
<ul>
  <li>Trauma-Informed Care Specialist</li>
  <li>Leadership, Advocacy and Education</li>
  <li>Specializing in – PTSD, somatic trauma, relationships, couples & family, addiction-related, and mindfulness therapies</li>
  <li>Telehealth Services, <strong>Mental Health Documentation & Medical Necessity</strong> – Clear guidelines for maintaining quality care and practice protection</li>
  <li><strong>Domestic & Intimate Partner Violence</strong> – Identification, documentation, reporting, and trauma-informed responses</li>
  <li><strong>DSM-5-TR™ Mastering Differential Diagnosis</strong> – Symptom-based diagnostic approach</li>
  <li><strong>Suicidal Ideation & Behavior Treatments</strong> – DBT, CT-SP, BCBT-SP, CAMS</li>
</ul>
<h4 class="skyblue mt-5">Certifications in Therapeutic Modalities and Approaches</h4>
<ul>
  <li><strong>Human Services Management Certificate</strong> – evidence-based leadership approaches, community support, client-care, financial oversight, and sustainable growth</li>
  <li><strong>Several EMDR Therapy trainings</strong> – EMDRIA Approved Consultant & Certified EMDR Therapist</li>
  <li><strong>Evidence-Based Approaches</strong> – Intensive and advanced training in:
  <ul class="type-circle mt-4">
    <li>Acceptance and Commitment Therapy (ACT)</li>
    <li>Animal-Assisted Therapy (AAT)</li>
    <li>Bowen Family Systems Theory (BFST)</li>
    <li>Cognitive Behavioral Family Therapy (CBFT) </li>
    <li>Cognitive Behavioral Therapy (CBT)</li>
    <li>Compassion-Focused Therapy (CFT)</li>
    <li>Culturally Sensitive Therapy (CST)</li>
    <li>Dialectical Behavior Therapy (DBT)</li>
    <li>Emotionally Focused Couples Therapy (EFCT)</li>
    <li>Emotionally Focused Family Therapy (EFFT)</li>
    <li>Grief Counseling</li>
    <li>Internal Family Systems (IFS)</li>
    <li>Mindfulness-Based Cognitive Therapy (MBCT) </li>
    <li>Motivational Interviewing</li>
    <li>Person-Centered Therapy (PCT)</li>
    <li>Problem-Solving Skills (PSS)</li>
    <li>Sandtray Therapy</li>
    <li>Solution-Focused Brief Therapy (SFBT)</li>
    <li>Structural Family Therapy</li>
    <li>Supportive Therapy</li>
    <li>Surf Therapy</li>
    <li>Trauma-Focused Cognitive Behavioral Therapy (TF-CBT)</li>
  </ul>
  </li>
</ul>
<h4 class="skyblue mt-5">Additional Training and Certifications</h4> 
<ul>
  <li><strong>Youth Suicide Intervention</strong> – Assessing and addressing suicidal ideation, intent, and behaviors in youth</li>
  <li><strong>Non-Medication Interventions for Sleep and Mental Health</strong> – Restoring sleep quality and improving outcomes</li>
  <li><strong>ADHD Interventions</strong> – Approaches beyond medication</li>
  <li><strong>Reducing Client Dropout</strong> – Strategies for client engagement</li>
  <li><strong>Suicide Assessment & Intervention</strong> – Confident and sensitive crisis intervention</li>
  <li><strong>Ethics of Digital Practice</strong> – Navigating ethical and legal considerations in online services</li>
  <li><strong>Fostering Hope in Suicidal Clients</strong> – Techniques for building resilience and hope</li>
  <li><strong>Psychopharmacology of Trauma</strong> – For prescribers and healthcare professionals</li>
</ul>
 
            </div>
          </div>
         
          </section>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" data-bs-target="#modalDrLindaTime" data-bs-toggle="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modalDrDavidTime" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Dr. David  Timme</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container">
          <section>
          <div class="row">
            <div class="col-12">
              <h4 class="title interiores pb-0"><span>David  Timme</span></h4>
              <h4 class="text-center mb-2">Physician Assistant</h4>
              <p>
                David Timme is a beloved Physician Assistant with over 45 years of experience in psychiatry. He is truly dedicated to enhancing mental health care and provides warm, evidence-based treatment to people from all walks of life. With a rich background in community mental health, private practice, and innovative psychiatric care, David is a trusted presence in his field.
</p>
<p>
                David's journey in medicine began with a heartfelt commitment to help those in need. Over the years, he has worked tirelessly in community settings, supporting individuals and families facing complex psychiatric challenges. His passion for making mental health services accessible has made a significant impact, especially in underserved communities where he approaches care with empathy and professionalism.
</p>
<p>
                In his private practice, David shines as a leader in psychiatric care, emphasizing patient-centered methods that focus on holistic well-being. His extensive knowledge allows him to blend the latest treatments with compassionate support, addressing not just the symptoms but also the root causes affecting his patients' mental health. David fosters trust and healing, helping his clients achieve lasting change.
</p>
<p>
                Another remarkable aspect of David’s career is his commitment to education and mentorship. He is always ready to guide and inspire budding healthcare professionals, sharing his wealth of knowledge and love for psychiatry. Many have benefited from his mentorship, which has helped shape promising careers in the mental health field.
</p>
<p>
                Outside of his clinical work, David enjoys collaborating on innovative projects that aim to improve mental health care delivery. His insights have driven initiatives aimed at expanding access to resources and incorporating new technologies into psychiatric practice. David's dedication to his patients and the mental health profession has earned him recognition throughout his career. His work continues to make a positive difference in countless lives and the community at large.
</p>
<p>
                Beyond his professional life, David is passionate about promoting resilience and wellness. Whether in his practice or daily interactions, he is on a mission to create a positive impact and support holistic well-being for everyone.

              </p>
            </div>
          </div>
</section>
<section class="mt-0 pt-4">
            <hr>
          <div class="row">
            <div class="col-12">
        
              <h4 class="skyblue mt-4">Services Offered:</h4>
              <ul>
                <li><strong>Professional Development</strong></li>
                <li><strong>Expert Consultation</strong></li>
                <li><strong>LENS Neurofeedback</strong></li>
                <li><strong>Transformative Retreats</strong></li>
                <li><strong>Meditation, Energy Healer, Yoga & Wellness Practitioner</strong></li>
              </ul>
              
<h4 class="skyblue mt-5">Holistic & Wellness Expertise:</h4>
<ul>
  <li><strong>Energy Healer Practitioner</strong></li>
  <li><strong>Wellness Practitioner</strong></li>
  <li><strong>Coach Practitioner</strong></li>
</ul>
  
            </div>
          </div>
         
          </section>

        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" data-bs-target="#modalDrDavidTime" data-bs-toggle="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modalDrFrances" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Dr. Frances Klaff</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container">
          <section>

            <div class="row">
              <div class="col-12">
                <h4 class="title interiores"><span>Dr. Frances Klaff</span></h4>
                <p>
                  Frances (Frankie) Klaff Ph.D is a clinical psychologist with over fifty years of experience in practice, both as a therapist and teacher/trainer. Her expertise in EMDR dates to its beginning, teaching and facilitating with EMDR’S creator, Dr. Francine Shapiro, at the EMDR Institute where she is still senior faculty. She is also a certified EMDRIA consultant and faculty for HAP, the humanitarian branch of EMDR.
                </p>
                <p>
                  Dr. Klaff has pioneered the application of EMDR to children and adolescents, teaching many workshops across the USA and internationally, and presenting at many EMDRIA international conferences.
                </p>
                <p>
                  She has contributed articles and reviews to the EMDR Clinical Research Journal and textbook chapters, including Francine Shapiro’s ‘EMDR Handbook of Family Therapy’. She edits research articles written by other world class academicians. Dr. Klaff was also trained in structural family therapy by its creator, Dr. Salvador Minuchin, and incorporated this approach into her EMDR work.
                </p>
                <p>
                  Born in South Africa, Dr. Klaff espouses a multi-cultural approach to her work. Her own close family in fact, spans the UK, Europe, Israel, Africa, Canada, South America and of course, the USA. She is loved for her humor and lively creative approach in teaching.
                </p>
                
              </div>
            </div>
          </section>

          <section class="mt-0 pt-4">
            <hr>
          <div class="row">
            <div class="col-12">
          
              <h3 class="text-center my-5">The Science of Connection: Neurobiology and Trauma-Informed Care for Youth and Families – A Practical Guide </h3>
              <ul>
                <li><strong>Dates:</strong> June 18, 2025</li>
                <li><strong>Time:</strong> 2 CEs</li>
                <li><strong>Location:</strong> Peñascal Beach, San Bartolo, Lima, Peru</li>
                <li><strong>Presenter:</strong> Frances (Frankie) Klaff, Ph.D.</li>
              </ul>
              <p class="my-5"><strong>Licensed Psychologist, EMDR Certified Consultant, EMDR Institute Senior Faculty</strong> </p>
          
              <h4>Course Description</h4>
              <p>
Therapists will expand on the ideas of how they support children, adolescents as well as their parents, by becoming an emotional “container” and co-regulator during the therapeutic process. The concept of the therapist’s authentic self, using creative, informal engagement will be demonstrated showing how it engenders trust which in turn facilitates the EMDR processing of memories. This is an area less explored in EMDR therapy.
This workshop will instruct using case material and videos, to illustrate the current neuroscientific research which presents the view that emotional processing is a key element in accessing cognitive change. The material demonstrates not only the theoretical points, but practical guidance is given to show how to process both traumatic memories and current issues, for both lasting change as well as symptom alleviation. The importance of the family therapy component is also demonstrated. The value of compassionate follow up is addressed. The interventions are delivered through direct therapeutic exploratory experiences, EMDR and integrative family participation.

</p>

<h4>Learning Objectives</h4>

<ul>
  <li><strong>Objective 1:</strong> Identify and describe at least two neuroscientific foundations of healing through compassionate purpose.</li>
  <li><strong>Objective 2:</strong> List and explain at least three key components of EMDR therapy for traumatized children, focusing on Phase 4 EMDR and real case applications.</li>
  
</ul>


            </div>
          </div>
          <hr>
 
          <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Hour Timeline: 9 AM - 11 AM</h3>
            </div>
          </div>
  
        <div class="row">
          <div class="col-12 text-start">
            <p>
              <strong>9:00 AM – 9:10 AM | Welcome & Introduction.</strong>
            </p>
            <ul class="mx-4">
              <li>Brief introduction of presenter</li>
              <li>Overview of presentation objectives</li>
              <li>Importance of trauma-informed care in working with youth and families</li>

            </ul>
            <p>
              <strong>9:10 AM – 9:20 AM | The Evolution of EMDR: A Neuroscientific Perspective.</strong>
            </p>
            <ul class="mx-4">
              <li>Brief history of EMDR and early misconceptions</li>
              <li>Development of the Eight Phases of EMDR Therapy</li>
              <li>Francine Shapiro’s emphasis on research and integration of EMDR with other modalities</li>
              <li>Key EMDR components:</li>
              <li>Target, Image, Cognition, Emotion, Sensation</li>
              <li>SUD, VOC, BLS (Eye movements and rhythmic stimulation)</li>
              
            </ul>
            <p>
              <strong> 9:20 AM – 10:00 AM | Case History: Antonio & Tommy Jefferson as Adults illustrating:</strong>
            </p>
            <ul class="mx-4">
              <li>How trauma impacts brain development</li>
              <li><strong>Introduction to Adaptive Information Processing (AIP) & memory processing</strong></li>
              <li>Preparing for <strong>Phase 3 EMDR</strong>: Connecting to the body</li>
              <li><strong>Social-emotional development</strong>: Phase 1 EMDR and history-taking across developmental stages</li>

              <li>Complex family dynamics and childhood trauma</li>
              <li>Foster care placement, removal, and reunification challenges</li>
              <li>The impact of attachment, loss, and resilience</li>
              <li>EMDR treatment interventions used throughout their journey</li>
              <li>The role of family therapy, school involvement, and community support</li>

            </ul>
            <p>
              <strong>10:00 AM – 10:50 AM | Video of EMDR Treatment of Antonio aged 9 and Tommy aged 6 and analysis of sessions illustrating: </strong>
            </p>
            <p>The therapeutic alliance as a key factor in healing</p>
            <ul class="mx-4">
              <li><strong>Neuroscience of attachment and safety:</strong>
                <ul class="mt-3 type-circle">
                  <li>Polyvagal Theory and emotional regulation</li>
                  <li>The heart-brain connection in trauma recovery</li>
                  <li>Mirror neurons and empathy in therapeutic engagement</li>
                </ul>
              </li>
              <li><strong>Integrative multimodal approaches in EMDR:</strong>
                <ul class="mt-3 type-circle">
                  <li>Play therapy, storytelling, sensory-motor work, and art therapy</li>
                  <li>Somatic interventions and trauma-focused cognitive restructuring</li>
                </ul>
              </li>

            </ul>
            <p>
              <strong>10:10 AM – 10:30 AM | Neuroscience & Resilience in Trauma Treatment.</strong>
            </p>
            <ul class="mx-4">
              <li>Carl Rogers’ empathic attunement and the role of feelings in therapy</li>
              <li>Minuchin’s structural family therapy: Changing family dynamics</li>
              <li>The neural symphony: How emotional states influence healing</li>
              <li>The importance of neuroplasticity and the brain’s ability to adapt after trauma</li>
              <li>Future research considerations: The impact of resilience on EMDR outcomes</li>
              <li>Techniques for building safety and trust in therapy</li>
              <li>Adapting EMDR for children in complex family systems</li>
              <li>Copilot and emotional container roles for the therapist</li>
              <li>Addressing resistance and readiness in trauma treatment</li>
              <li>Open Q&A and clinical reflections</li>
            </ul>
            <p>
              <strong>10:50 AM – 11:00 AM | Closing Remarks & Takeaways.</strong>
            </p>
            <ul class="mx-4">
              <li>Summary of key insights</li>
              <li>Final reflections on integrating EMDR and Family Systems Therapy</li>
              <li>Resources for continued learning and professional development</li>
              <li>Thank you & contact information</li>

            </ul>
          </div>
        </div>
         
   
          </section>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" data-bs-target="#modalDrFrances" data-bs-toggle="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modalDrCio" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Dr. Cio Hernández</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container">
          <section>
          <div class="row">
            <div class="col-12">
              <h4 class="title interiores"><span>Dr.Cio Hernández</span></h4>
              <h3 class="text-center mb-5">Understanding Childhood Trauma for Grown-ups</h3>
              <p>
                Dr. Cio Hernández is CEO and founder of Got This! Inc. and The Be It Foundation.  She is a psychotherapist in California, Texas, and Hawaii where she specializes in goal-getting, anxiety, relationships, safety through connection, childhood and trauma.  In her private practice, she offers EMDR and other modalities to replace haunting memories with a new outlook on life or to help people reach a positive life goal...any goal... 
</p>
<p>
                For over 20 years she has worked on public health policy, led many community initiatives, served as a bilingual Public Information Officer, been on the Kaiser IRB research board, taught continuing education, and has served as a First 5 Children and Families Commissioner for over 16 years. 
</p>
<p>
                Dr. Cio lives her values of ubiquitous synchronicity by tackling whole person care and health parity from the individual to the inclusive collective. She is the President and Founder of Levelation International, a nonprofit whose mission is to promote world resilience.  Her health care leadership doctoral research in test-anxiety using her first version of Got This! App has now been applied to university and academic strategies to increase the professional pipeline for health and other fields.  Her corporate plans have been sought to improve the almost 50% of the workforce struggling with personal issues that get manifested in the workforce.  Cio sees a world where coping is elevated for all, to promote playful co-existence in a safe and connected world. Although Cio believes in making work a playground for growth, she loves to play too.  She runs half-marathons around the world, enjoys exploring new spaces, and loves talking to strangers.
</p>


            </div>
          </div>
          </section>
          <section class="mt-0 pt-4">
            <hr>
          <div class="row">
            <div class="col-12">
          
              <h3 class="text-center my-5">Understanding Child Trauma for Grown-ups</h3>
              <ul>
                <li><strong>Dates:</strong> June 17–18, 2025</li>
                <li>June 17: 9:00 AM – 2:00 PM</li>
                <li>June 18: 11:15 AM – 2:15 PM</li>
                <li><strong>Location:</strong> Peñascal Beach, San Bartolo, Lima, Peru</li>
                <li><strong>Presenter:</strong> Rocio Hernandez, PhD, LPCC, LMFT</li>
              </ul>
              <p class="my-5"><strong>Elevate Your Professional Growth with Accredited Continuing Education!</strong> </p>
              <ul>
                <li><strong>6.5 CE credits approved</strong> (CAMFT CEPA #146123)</li>
                <li><strong>EMDRIA Credits:</strong> 6.5 📜 <strong>EC Program Approval Number:</strong> #20011-01</li>
                <li><strong>Soon to be approved by NBCC, APA, and ASWB via co-sponsorship</strong></li>
              </ul>
              <h4 class="my-4">Course Overview</h4>
              <p>
<strong>Why do some children and adults seem more resilient than others?</strong>
</p>
<p>
Have you noticed that some individuals freeze in stressful situations while others react differently?
</p>
<p>
This comprehensive training explores the neuroscience of childhood trauma, helping participants understand how the brain and behavior interact in response to trauma and adversity. By integrating the Adaptive Information Processing (AIP) Model with Polyvagal Theory and EMDR Therapy, this course provides practical strategies for trauma-informed interventions.             
</p>

<p>Participants will learn how to:</p>

<ul>
  <li><strong>Understand trauma’s impact</strong> on brain development and behavior</li>
  <li><strong>Recognize symptoms and root causes</strong> of childhood trauma</li>
  <li><strong>Apply EMDR & Polyvagal Theory techniques</strong> to improve resilience</li>
  <li><strong>Address trauma’s influence</strong> in schools, workplaces, and relationships</li>
</ul>

<p class="font-weight-bold">This training is essential for mental health professionals, educators, and caregivers seeking to create meaningful change in trauma recovery.</p>


            </div>
          </div>
          <hr>
          <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Educational Goals</h3>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <ul>
                <li>Increase awareness of the complexities of childhood trauma</li>
                <li>Interrupt physiological processes that hinder healthy development</li>
                <li>Provide practical tools to shift from trauma’s impact to empowered healing</li>
                <li>Equip professionals with evidence-based interventions to foster resilience</li>
              </ul>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Learning Objectives</h3>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <p>By the end of this course, participants will:</p>
              <ul>
                <li><strong>Understand the Brain & Trauma Response</strong>
                  <ul class="mt-3 type-circle">
                    <li>Identify 10 key brain structures and nervous system components involved in managing anxiety, safety, and trauma.</li>
                  </ul>
                </li>
                <li><strong>Apply Polyvagal Theory in Trauma Treatment</strong>
                  <ul class="mt-3 type-circle">
                    <li>Recognize three core principles of Polyvagal Theory and differentiate between ventral and dorsal vagus nerve functions in trauma response.</li>
                  </ul>
                </li>
                <li><strong>Address Legal & Ethical Considerations</strong>
                  <ul class="mt-3 type-circle">
                    <li>Identify 12 essential legal and ethical considerations in assessing and treating childhood trauma.</li>
                  </ul>
                </li>
                <li><strong>Implement Evidence-Based Trauma Interventions</strong>
                  <ul class="mt-3 type-circle">
                    <li>Demonstrate 15 research-backed interventions to regulate anxiety, process trauma, and foster emotional connectedness.</li>
                  </ul>
                </li>
                <li><strong>Integrate the AIP Model & EMDR Therapy for Childhood Trauma</strong>
                  <ul class="mt-3 type-circle">
                    <li>Apply the AIP Model through EMDR’s eight-phase protocol, ensuring effective trauma processing for children.</li>
                  </lu>
                </li>
                
              </ul>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Program Schedule</h3>
            </div>
          </div>
          <div class="row">
          <div class="col-12 text-start">
            <h4 class="skyblue">Day 1: June 16, 2025</h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <p>
              <strong>8:00 AM: Registration & Networking.</strong>
            </p>
            <ul class="mx-4">
              <li>Connect with fellow participants</li>
              <li>Review program materials</li>
              
            </ul>
            <p>
              <strong>9:00 AM: Program Overview.</strong>
            </p>
            <ul class="mx-4">
              <li>Introduction to course objectives</li>
              <li>The <strong>Spectrum of the Problem</strong>: Understanding childhood trauma</li>
              
            </ul>
            <p>
              <strong>9:40 AM: Child Brain Development & Trauma.</strong>
            </p>
            <ul class="mx-4">
              <li>How trauma impacts brain development</li>
              <li><strong>Introduction to Adaptive Information Processing (AIP) & memory processing</strong></li>
              <li>Preparing for <strong>Phase 3 EMDR</strong>: Connecting to the body</li>
              <li><strong>Social-emotional development</strong>: Phase 1 EMDR and history-taking across developmental stages</li>

            </ul>
            <p>
              <strong>9:45 AM: Break </strong>
            </p>
            <ul class="mx-4">
              <li>How trauma impacts brain development</li>
              <li><strong>Introduction to Adaptive Information Processing (AIP) & memory processing</strong></li>
              <li>Preparing for <strong>Phase 3 EMDR</strong>: Connecting to the body</li>
              <li><strong>Social-emotional development</strong>: Phase 1 EMDR and history-taking across developmental stages</li>

            </ul>
            <p>
              <strong>11:00 AM: Understanding Trauma & The Brain.</strong>
            </p>
            <ul class="mx-4">
              <li><strong>What is trauma?</strong> Defining trauma from a neuroscience perspective</li>
              <li><strong>Polyvagal Theory & EMDR:</strong> The role of the nervous system in healing</li>


            </ul>
            <p>
              <strong>1:00 AM: Legal & Ethical Considerations.</strong>
            </p>
            <ul class="mx-4">
              <li>Understanding child abuse laws and reporting requirements</li>
              <li>Ethical considerations in working with traumatized children</li>

            </ul>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <h4 class="skyblue">
              Days 2: June 17, 2025
            </h4>
          </div>
        </div>
        <div class="row">
          <div class="col-12 text-start">
            <p><strong>11:15 AM: Childhood Trauma in the Workplace & Relationships.</strong></p>
            <ul class="mx-4">
              <li>How childhood trauma affects adult relationships & professional settings.</li>
              <li>Recognizing trauma-informed approaches in organizational and relational contexts</li>

            </ul>
            <p><strong>1:00 PM: Practical Interventions for Traumatized Children.</strong></p>
            <ul class="mx-4">
              <li><strong>EMDR Therapy across the lifespan:</strong> Addressing childhood trauma from infancy to adulthood</li>
              <li>Trauma-informed strategies for working with children at different developmental stages</li>

            </ul>
            <p><strong>2:15 PM: Q&A & Closing Reflections.</strong></p>
            <ul class="mx-4">
              <li>Open discussion and participant reflections</li>
              <li>Final thoughts on integrating EMDR & trauma-informed care into practice</li>

            </ul>
           
          </div>
        </div>

      
      
          <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Why Attend?</h3>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <ul>
                <li>Gain hands-on experience with practical trauma-informed techniques</li>
                <li>Learn cutting-edge neuroscience behind trauma healing</li>
                <li>Develop real-world skills for supporting children & families</li>
                <li>Be part of a collaborative and engaging learning experience</li>

              </ul>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Who Should Attend?</h3>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <ul>
                <li>Mental Health Professionals</li>
                <li>EMDR Practitioners</li>
                <li>Educators & School Counselors</li>
                <li>Child and Family Therapists</li>

              </ul>
            </div>
          </div>
          </section>
          <section>
            <hr>
            <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Optional Courses</h3>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="skyblue">1. Got This! Stress Busters & Confidence Builders</h4>
              <p class="font-weight-bold">Ambassador/Promotora Certificate Program</p>
              <ul>
                <li><strong>Duration:</strong> 7.5-hour course</li>
                <li><strong>Presenter:</strong> Rocio Hernandez, PhD, LPCC, LMFT</li>
              </ul>
              <p><strong>Elevate Your Professional Growth with Accredited Continuing Education (CE) credits!</strong></p>
              <ul>
                <li><strong>7.5 CE credits approved</strong> (CAMFT CEPA Provider #146123)</li>
              </ul>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">Empower Yourself & Your Community with Evidence-Based Stress Management!</h4>
              <p>Stress is an unavoidable part of life—whether from work, relationships, parenting, or personal challenges. <strong>Got This!</strong> is a powerful <strong>train-the-trainer certification program</strong> designed to equip <strong>community members, providers, and professionals</strong> with effective self-help techniques that reduce stress and <strong>boost confidence in as little as one minute!</strong></p>
              <p>This training will introduce the <strong>Got This! App</strong>, an innovative, evidence-based tool that integrates:
                <ul class="font-weight-bold">
                  <li>EMDR techniques</li>
                  <li>Cognitive-behavioral strategies</li>
                  <li>Positive psychology</li>
                  <li>Meditation & relaxation</li>
                  <li>Tapping, goal-setting, laughter yoga, and more!</li>
                </ul>
              </p>
              <p class="font-weight-bold">Join us in building resilient communities and fostering post-traumatic growth!</p>
 
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">What You’ll Gain</h4>
                <ul>
                  <li>Hands-on training with the <strong>Got This! App</strong> for stress management</li>
                  <li>A deeper understanding of <strong>EMDR, neuroplasticity, and positive psychology</strong></li>
                  <li><strong>Train-the-trainer certification</strong> to share these life-changing tools with others</li>
                  <li>Techniques to <strong>support self-care & mental well-being</strong> between therapy sessions</li>
                  <li>A <strong>global wellness movement</strong> — currently available in multiple languages</li>
                </ul>
              </p>
 
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">Learning Objectives</h4>
              <p>By the end of this course, participants will:</p>
                <ol> 
                  <li><strong>Explore 10 Self-Help Approaches in a Digital Format</strong>
                    <ul class="type-circle mt-3">
                      <li>Learn how electronic interventions can support mental wellness and emotional resilience.</li>
                    </ul>
                  </li>
                  <li><strong>Integrate Strength-Based, Evidence-Based Approaches within the AIP Framework</strong>
                    <ul class="type-circle mt-3">
                      <li>Understand positive psychology, solution-focused techniques, and goal-setting tools.</li>
                    </ul>
                  </li>
                  <li><strong>Apply SMART Goals for Treatment Planning & Target Mapping</strong>
                    <ul class="type-circle mt-3">
                      <li>Utilize goal-setting frameworks to create measurable, actionable treatment plans.</li>
                    </ul>
                  </li>
                  <li><strong>Learn to Apply the 8 Phases of EMDR Using Digital Tools</strong>
                    <ul class="type-circle mt-3">
                      <li>Explore how EMDR therapy can be adapted for self-guided and digital platforms.</li>
                    </ul>
                  </li>
                  <li><strong>Utilize the Got This! Progress Tracker for Coaching & EMDR Notes</strong>
                    <ul class="type-circle mt-3">
                      <li>Learn ethical record-keeping practices for tracking progress in digital interventions.</li>
                    </ul>
                  </li>
                  <li><strong>Implement Electronic Interventions in Group Therapy</strong>
                    <ul class="type-circle mt-3">
                      <li>Apply digital tools in group settings to enhance trauma healing and stress reduction.</li>
                    </ul>
                  </li>
                </ol>
              
            </div>
          </div>

          <div class="row">
            <div class="col-12">
              <h4 class="mt-5 skyblue">2. Brain Spa: The Ultimate Reset for Your Mind & Body</h4>
              <ul>
                <li><strong>Duration:</strong> 3-hour course</li>
                <li><strong>Presenter:</strong> Dr. Rocio Hernandez, PhD, LPCC, LMFT</li>
              </ul>
              <p><strong>Elevate Your Professional Growth with Accredited Continuing Education! </strong></p>
              <ul>
                <li><strong>3 CE credits approved </strong> (CAMFT CEPA Provider #146123)</li>
              </ul>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">Unlock Deep Relaxation & Mental Clarity</h4>
              <p>Ever feel like your brain and body need a full recharge—like swapping out a drained battery for a fresh one?</p>
              <p><strong>Welcome to Brain Spa</strong>, a transformative sanctuary where <strong>stress dissolves, your nervous system finds balance, and your inner child is reawakened</strong>. Through neuroscience-backed techniques, sensory-based healing, and playful self-discovery, this immersive experience will <strong>leave you feeling rejuvenated, refreshed, and empowered</strong>.</p>
              
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">What to Expect</h4>
                <ul>
                  <li><strong>Cutting-edge neurotherapy & brain optimization techniques</strong></li>
                  <li><strong>Quick brain hacks & vagus nerve exercises</strong> to restore balance</li>
                  <li><strong>Somatosensory practices</strong> for emotional attunement & self-regulation</li>
                  <li><strong>Mindfulness, movement, and laughter therapy</strong> to rewire stress responses</li>
                  <li><strong>A deep sense of peace, clarity, and connection to yourself</strong></li>
                </ul>
              </p>
 
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">Learning Objectives</h4>
              <p>By the end of this immersive experience, participants will:</p>
                <ol> 
                  <li><strong>Explore Complementary Brain-Boosting Modalities</strong>
                    <ul class="type-circle mt-3">
                      <li>Learn about <strong>Low Energy Neurofeedback, Myocalme, Red Light Therapy, EMDR devices,</strong> and other cutting-edge tools for mental wellness.</li>
                    </ul>
                  </li>
                  <li><strong>Experience Somatosensory Techniques for Nervous System Regulation</strong>
                    <ul class="type-circle mt-3">
                      <li>Engage in <strong>five simple somatosensory exercises</strong> to enhance self-awareness, regulate stress, and activate the <strong>parasympathetic nervous system</strong>.</li>
                    </ul>
                  </li>
                  <li><strong>Identify & Integrate Ego States for Inner Balance</strong>
                    <ul class="type-circle mt-3">
                      <li>Explore <strong>personalized ego states</strong> using <strong>Eriksonian developmental stages, Internal Family Systems, and Gestalt approaches</strong>.</li>
                    </ul>
                  </li>
                  <li><strong>Cultivate Sustainable Self-Care Practices</strong>
                    <ul class="type-circle mt-3">
                      <li>Develop <strong>practical, neuroscience-based strategies to maintain emotional resilience and long-term well-being.</strong></li>
                    </ul>
                  </li>
                   
                </ol>
              </p>
            </div>
          </div>

          <div class="row">
            <div class="col-12">
              <h4 class="mt-5 skyblue">3. EMDR Diversity & The Spectrum of Trauma Prevention</h4>
              <p class="font-weight-bold">Ambassador/Promotora Certificate Program</p>
              <ul>
                <li><strong>Duration:</strong> 3-hour course</li>
                <li><strong>Presenter:</strong> Dr. Rocio Hernandez, PhD, LPCC, LMFT</li>
              </ul>
              <p><strong> Your Professional Growth with Accredited Continuing Education!</strong></p>
              <ul>
                <li><strong>Approval for 3 Continuing Education (CE) credits </strong></li>
                <li><strong>Earn approved continuing education hours </strong> (CAMFT CEPA Provider #146123)</li>
              </ul>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">Workshop Overview</h4>
              <p>This interactive and <strong>thought-provoking workshop</strong> challenges participants to <strong>examine the spaces we occupy and the roles we play in trauma prevention and healing</strong>.
Dr. Rocio Hernandez will share <strong>insights and real-world applications</strong> of <strong>Eye Movement Desensitization and Reprocessing (EMDR) across diverse populations,</strong> mapping it onto the <strong>Spectrum of Prevention</strong> framework.
</p>
              <p><strong>Beyond race and ethnicity, diversity in mental health includes identity, accessibility, and systemic barriers to trauma-informed care</strong>.</p>
              <p>This workshop invites you to explore how <strong>trauma prevention spans from individual interventions to policy-level advocacy</strong>, ensuring <strong>mental health services are equitable and accessible for all</strong>.</p>
 
 
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">Key Topics Covered</h4>
                <ul>
                  <li><strong>The intersection of race, identity, and inclusion in trauma therapy</strong></li>
                  <li><strong>Expanding EMDR accessibility across diverse populations</strong></li>
                  <li><strong>The Spectrum of Prevention framework in trauma care</strong></li>
                  <li><strong>The SPACE HOGS acronym</strong> for understanding diversity issues</li>
                  <li><strong>Real-world case examples:</strong> Immigration, unlearning racism, and adapting EMDR for accessibility</li>
                </ul>
              </p>
 
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <h4 class="my-4">Who Should Attend?</h4>
              <ul class="font-weight-bold">
                <li>Mental Health Professionals & EMDR Practitioners</li>
                <li>Social Workers & Trauma-Informed Care Providers</li>
                <li>Advocates for Diversity, Equity, & Inclusion in Mental Health</li>
              </ul>
            
            </div>
          </div>
          </section>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" data-bs-target="#modalDrCio" data-bs-toggle="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modalSarita" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalToggleLabel">Sarita Molinar</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container">
          <section>
          <div class="row">
            <div class="col-12">
              <h4 class="title interiores"><span>Sarita Molinar</span></h4> 
              <h4 class="text-center mb-2">LPC, Art Therapist, EYT-200</h4>
              <p>
                Sarita Molinar is an integrative mental health professional who strives to combine therapeutic modalities in a creative and holistic way.  Her experience in education, art therapy, and yoga have allowed her to apply, first hand, the techniques that bring flow to self-discovery in herself and her clients. 
</p>
<p>
                In 2007, Sarita acquired a Bachelor’s degree in Studio Art at Texas State University which launched her career as a Visual Artist in painting and fiber sculpture. In 2015, while perusing her Master’s at Saint Mary-of-the-Woods College in Indiana, she offered art therapy in public schools for Life Skills students as well as Dell Children’s Medical Hospital in Austin, TX. She then went on to train in Vinyasa, in 2021, with Black Swan Yoga for her own health and exploration of somatic therapy. 
</p>
<p>
                Sarita saw a need for enhanced group work in the community when working with at- risk youth in high school. She began her private practice in 2022, offering Art Therapy, Accelerated Resolution Therapy, and iRest Yoga Nidra to teens and adults. She was accepted for the Be It! Foundation award to train in Advanced LENS Neurofeedback and most recently Francine Shapiro’s EMDR. Sarita will continue with EMDR Consultant training track to advance toward her own EMDR training program in the future. It is her goal to provide the most up to date and effective applications of EMDR to her community in South Texas and virtually. 
</p>
<p>
  Through an art therapy LENS, Sarita has explored and discovered numerous ways to spark her client’s creativity. In doing so, she feels that this can expand all threads of awareness and enhances the innate healing experience. 
Sarita recently won runner up for 2024 Austin’s Best Mental Health Professional in Austin Fit Magazine, bringing her increased notoriety for her unique approach to working with attachment, Identity, family, anxiety, depression, and chronic pain, among many other issues, by applying a holistic approach to psychotherapy. 

</p>

            </div>
          </div>
          </section>
          <section class="mt-0 pt-4">
             <hr>
          <div class="row">
            <div class="col-12">
          
              <h3 class="text-center my-5">Seeing is Healing: How Imagery Reshapes the Mind and Body in Four Therapeutic Modalities</h3>
              <ul>
                <li><strong>Dates:</strong> June 19, 2025</li>
                <li><strong>Time:</strong> 9:00 AM – 1:00 PM (4 CEs)</li>
                <li><strong>Location:</strong> Peñascal Beach, San Bartolo, Lima, Peru</li>
                <li><strong>Presenter:</strong> Sarita Molinar, ATR, LPC, EYT-200.</li>
              </ul>
              <p class="mt-5"><strong>Elevate Your Professional Growth with Accredited Continuing Education! </strong> </p>
              <ul>
                <li>CE credits approved (CAMFT CEPA Provider #146123)</li>
                <li>Soon to be approved by NBCC, APA, and ASWB via co-sponsorship</li>
              </ul>
              <h4 class="mt-5">Course Overview</h4>
              <p>How does imagery reshape the brain, nervous system, and emotional responses?</p>
              <p>
Imagery is a powerful tool in therapy—activating the nervous system, regulating emotions, and facilitating trauma resolution. This experiential workshop explores four therapeutic modalities—Art Therapy, EMDR, Accelerated Resolution Therapy (ART), and iRest Yoga Nidra—to demonstrate how imagery promotes cognitive, emotional, and energetic healing.
</p>
<p>
  Participants will gain hands-on experience in using imagery for trauma processing, emotional regulation, and deep relaxation. Whether through art-based interventions, EMDR desensitization, ART voluntary image replacement, or guided iRest meditation, imagery transforms both the mind and body—enhancing therapeutic outcomes.
</p>
<p>Through interactive exercises and clinical applications, this workshop will provide tools to integrate imagery-based techniques into your practice.</p>

<h4 class="mt-5">Learning Objectives</h4>

<ul>
  <li><strong>Describe the Role of Imagery in Therapy</strong><br>Understand how imagery affects emotional and physiological responses, influencing stress and trauma processing.</li>
  <li><strong>Summarize the Use of Imagery in Art Therapy</strong><br>Explore how drawing, visual storytelling, and creative expression enhance emotional regulation and trauma resolution.</li>
  <li><strong>Explain How EMDR Uses Imagery for Trauma Processing</strong><br>Learn how bilateral stimulation and visual desensitization rewire distressing memories.</li>
  <li><strong>Identify How Accelerated Resolution Therapy (ART) Utilizes Imagery</strong><br>Understand ART’s Voluntary Image Replacement (VIR) technique to replace distressing images with positive imagery.</li>
  
</ul>


            </div>
          </div>
          <hr>
 
          <div class="row">
            <div class="col-12">
              <h3 class="text-center my-4">Course Schedule</h3>
            </div>
          </div>
  
        <div class="row">
          <div class="col-12 text-start">
            <p>
              <strong>9:00 AM – 9:05 AM | Welcome & Overview</strong>
            </p>
            <ul class="mx-4">
              <li>Introduction to workshop goals, format, and participant expectations</li>
              <li>Overview of imagery, therapeutic modalities, and their effects on emotional regulation</li>
            </ul>
            <p>
              <strong>9:05 AM – 9:20 AM | Introduction to Imagery & the Autonomic Nervous System (ANS)</strong>
            </p>
            <ul class="mx-4">
              <li>How imagery regulates fight-or-flight vs. rest-and-digest responses</li>
              <li>Overview of neurobiological mechanisms of imagery in therapy</li>
              <li>Review of key research on imagery’s role in emotional processing</li>              
            </ul>
            <p>
              <strong>9:25 AM – 10:10 AM | Art Therapy & Imagery for Emotional Processing</strong>
            </p>
            <ul class="mx-4">
              <li>Introduction to Art Therapy as a modality for emotional healing</li>
              <li>Activating vs. soothing art techniques to engage the nervous system</li>
              <li>Hands-On Art Exercise: Participants will create a therapeutic collage using imagery to evoke and process emotions</li>
            </ul>
            <p>(10–15 Minute Break)</p>
            <p>
              <strong>10:30 AM – 11:10 AM | EMDR & Desensitizing Traumatic Imagery</strong>
            </p>
            <ul class="mx-4">
              <li>Introduction to EMDR Therapy and its use of imagery to process trauma</li>
              <li>Explanation of bilateral stimulation for nervous system regulation</li>
              <li>Experiential Exercise: Guided EMDR practice using imagery-based desensitization</li>
            </ul>  
            <p>
              <strong>11:10 AM – 11:50 AM | ART & Replacing Traumatic Imagery</strong>
            </p>
            <ul class="mx-4">
              <li>Overview of Accelerated Resolution Therapy (ART) and Voluntary Image Replacement (VIR)</li>
              <li>How ART helps reset the nervous system by replacing distressing images</li>
              <li>Guided ART Exercise: Participants will practice VIR techniques through art or guided imagery exercises</li>
            </ul>

            <p>
              <strong>11:50 AM – 12:50 PM | iRest Yoga Nidra & Guided Imagery for Relaxation</strong>
            </p>
            <ul class="mx-4">
              <li>Introduction to iRest Yoga Nidra and its use of imagery for deep relaxation</li>
              <li>Sankalpa, Body Sensing, and Breathwork to calm the nervous system</li>
              <li>Guided iRest Yoga Nidra Session: Participants will experience deep relaxation techniques to support clients with anxiety, PTSD, and chronic stress</li>
            </ul>

            <p>
              <strong>12:50 PM – 1:00 PM | Closing Reflection & Integration</strong>
            </p>
            <ul class="mx-4">
              <li>Discussion on integrating imagery-based techniques into clinical practice</li>
              <li>Participants share insights on applying Art Therapy, EMDR, ART, and Yoga Nidra</li>
              <li>Final reflections & Q&A session</li>
            </ul>
          </div>
        </div>
         
   
          </section>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" data-bs-target="#modalSarita" data-bs-toggle="modal">Close</button>
      </div>
    </div>
  </div>
</div>
<?php include('_request-an-appointment.php');?>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css"
/>
<script>
      Fancybox.bind('[data-fancybox="gallery"]', {
        //
      });    
    </script>
<?php include('footer.php');?>